/********************************************************************

  Module: TiBitmapInfo

  Author: Carlo Ordonez

  Description:

    An image's surface ID and dimensions

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiBitmapInfo_h_
#define _TiBitmapInfo_h_

#include "SyVect2I.h"

class TiBitmapInfo
{
public:

  SyVect2I  GetSurfaceOffset() const { return( mUV[0] ); }
  int32     GetWidth() const { return( mUV[1].X - mUV[0].X ); }
  int32     GetHeight() const { return( mUV[2].Y - mUV[1].Y ); }

  int32     mSurfaceResourceID;
  SyVect2I  mUV[4];
};


#endif

