/********************************************************************

  Module: TiCharacterCreateMessage

  Author: Carlo Ordonez

  Description:

    Messages coming from character creation screens

  Copyright 2006 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiCharacterCreateMessage_h_
#define _TiCharacterCreateMessage_h_

#include "TiWindowMessage.h"
#include "SyString.h"

static const int32 TI_CREATE_CLASS      = 0x01;
static const int32 TI_CREATE_NAME       = 0x02;

class TiCharacterCreateMessage : public TiWindowMessage
{
public:
  TiCharacterCreateMessage( TiWindow* pSender, int32 CharacterMessageId )
    : TiWindowMessage( pSender, TIWINDOW_CHARACTER_CREATE )
  {
    mCharacterMessageId = CharacterMessageId;
    mClass = 0;
    mName.Init("");
  }

  int32     GetCharacterMessageId() const { return( mCharacterMessageId ); }

  int32     GetClass() const { return( mClass ); }
  void      SetClass( int32 Class ) { mClass = Class; }

  const SyString& GetName() const { return( mName ); }
  void            SetName( const SyString& Name ) { mName = Name; }

private:

  int32     mCharacterMessageId;
  int32     mClass;
  SyString  mName;
};

#endif

