/********************************************************************

  Module: TiCharacterPage

  Author: Jon Wiesman

  Description:

    Character page base class (inventory, stats, skills, quests)

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#include "TiCharacterPage.h"

///////////////////////////////////////////////////////////////////////////////
// TiCharacterPage
///////////////////////////////////////////////////////////////////////////////

TiSprite    TiCharacterPage::sm_sprEquipBG;
TiSprite    TiCharacterPage::sm_sprOtherBG;
TiBoxDraw   TiCharacterPage::sm_bdFrame;
TiBoxDraw   TiCharacterPage::sm_bdSelection;

TiCharacterPage::TiCharacterPage(TiWindow *pParent, TiCharacterData *pData, int32 iPlayerId, ECharacterPage ePage) :
  TiWindow(pParent), m_iPlayer(iPlayerId), m_pData(pData), m_ePage(ePage)
{
  static bool bSpritesInit = false;
  if(!bSpritesInit)
  {
    sm_sprEquipBG.SetInfo("menu_equip.tga");
    sm_sprOtherBG.SetInfo("menu_stats.tga");
    sm_bdFrame.Initialize("Frame");
    sm_bdSelection.Initialize("Selection");

    bSpritesInit = true;
  }
}

TiCharacterPage::~TiCharacterPage()
{
}

void TiCharacterPage::DrawBackground()
{
  TiPoint pt = GetScreenRect().TopLeft();
  int32 iTab = m_ePage;

  if(iTab == kEquipment)
  {
    sm_sprOtherBG.Draw(pt);
    sm_sprEquipBG.Draw(pt);
  }
  else
  {
    sm_sprOtherBG.Draw(pt);
  }

  pt = GetScreenRect().TopLeft();
}


void TiCharacterPage::OnSelectPage()
{
}

void TiCharacterPage::OnUnselectPage()
{
}
