/********************************************************************

  Module: TiCharacterPage

  Author: Jon Wiesman

  Description:

    Character page base class (inventory, stats, skills, quests)

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiCharacterPage_h_
#define _TiCharacterPage_h_

#include "TiWindow.h"
#include "TiSprite.h"
#include "TiBoxDraw.h"

class TiUIControl;
class TiUILayout;
class TiCharacterData;


///////////////////////////////////////////////////////////////////////////////
// TiCharacterPage
///////////////////////////////////////////////////////////////////////////////

enum ECharacterPage
{
  kEquipment,
  kEnhancements,
  kStats,
  kSkills,
  kQuests,
  kMaxPages,
};

class TiCharacterPage : public TiWindow
{
public:
  TiCharacterPage( TiWindow* pParent, TiCharacterData* pData, int32 nPlayerId, ECharacterPage ePage );
  ~TiCharacterPage();

  virtual void      OnSelectPage();
  virtual void      OnUnselectPage();

protected:
  void              DrawBackground();

  ECharacterPage    m_ePage;
  int32				      m_iPlayer;
  TiCharacterData   *m_pData;

  static TiSprite   sm_sprEquipBG;
  static TiSprite   sm_sprOtherBG;
  static TiBoxDraw  sm_bdFrame;
  static TiBoxDraw  sm_bdSelection;
  
};


#endif

