/******************************************************************

  Module: TiChildFrameDraw.h

  Author: Jon Wiesman

  Description:

    child frame drawing class

  Copyright 2006 Sony Online Entertainment.  All rights reserved.

*******************************************************************/

#ifndef __TiChildFrameDraw_h__
#define __TiChildFrameDraw_h__

#include "TiBoxDraw.h"

class TiChildFrameDraw
{
  static TiBoxDraw  sm_bdFrame;
  static TiBoxDraw  sm_bdScrollbarUp;
  static TiBoxDraw  sm_bdScrollbarDown;
  static TiBoxDraw  sm_bdScrollbarBG;

  static TiSprite   sm_sprBackground;
  static TiSprite   sm_sprUpArrow;
  static TiSprite   sm_sprDownArrow;
  static TiSprite   sm_sprThumb;

  bool    m_bScrollbar;
  int32   m_nRange;
  int32   m_nPos;

public:
  TiChildFrameDraw(bool bScrollbar = false, int32 nRange = -1);

  void    SetScrollbar(bool bScroll) {m_bScrollbar = bScroll;}
  void    SetRange(int32 nRange) {m_nRange = nRange; m_nPos = SY_CLAMP(m_nPos, 0, m_nRange);}
  int32   GetRange() const {return m_nRange;}
  void    SetPos(int32 nPos) {m_nPos = SY_CLAMP(nPos, 0, m_nRange);}
  int32   GetPos() const {return m_nPos;}

  void    Draw(TiRect rectBox, float fOpacity = 1.f) const;
  TiRect  GetContentRect(TiRect rectBox) const ;
};

#endif

