/********************************************************************

  Module: TiClassWindow

  Author: Carlo Ordonez

  Description:

    Panel for choosing a new character's class

  Copyright 2006 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#include "TiClassWindow.h"
#include "TiFocusMessage.h"
#include "TiCharacterCreateMessage.h"
#include "TiUIControl.h"
#include "TiUI.h"

//***********************************************************************
// Constructor/Destructor
//***********************************************************************

TiClassWindow::TiClassWindow( TiWindow* pParent )
: TiWindow( pParent )
{
  mpCtrl = SyNew TiUIControl();
  mpButtons = SyNew TiUIControl();

  mSelection = 0;
}

TiClassWindow::~TiClassWindow()
{
  delete mpCtrl;
  delete mpButtons;
}

//***********************************************************************
// DrawSelf
//***********************************************************************

// todo: get these from T4
const char8* sNames[3] =
{
  "Golan Kor - The Brute",
  "Malakesh - The Mage",
  "Jhazala - The Scout"
};

const char8* sDescriptions[3] =
{
  "Strongest of the three characters.  Can pick up and throw very heavy objects.",
  "Fights with a staff and innate magic.  Many of his moves are magic based.",
  "Fastest of the three characters.  Fights with swords and bladed weapons."
};

void TiClassWindow::DrawSelf()
{
  int32 w, h;
  TiUI::Instance()->GetDisplaySize( &w, &h );

  mSelection = SY_CLAMP( mSelection, 0, 2 );

  SyString buttons;
  switch( mSelection )
  {
  case 0:
    buttons = "|xSelect  |cBack  Next|V";
  	break;
  case 1:
    buttons = "|vPrev  |xSelect  |cBack  Next|V";
    break;
  case 2:
    buttons = "|vPrev  |xSelect  |cBack";
    break;
  }

  int32 margin = 20;
  int32 tbWidth = mpButtons->GetTextWidth(buttons.AsChar());

  mpButtons->Init( SyVect2I(w>>1, h-75), tbWidth+(margin<<1), 1, TiUIControl::kBlack );
  mpButtons->Draw();
  mpButtons->DrawTextBox( buttons.AsChar(), margin, 0, tbWidth, 1, TiUIControl::kNormal, TI_TF_SHADOW|TI_TF_HALIGN_CENTER );

  int32 rows = 8;
  tbWidth = w / 3;

  mpCtrl->Init( tbWidth+(margin<<1), rows );
  mpCtrl->Draw();
  mpCtrl->DrawTextBox( "Choose a Character", margin, 0, tbWidth, 1, TiUIControl::kNormal, TI_TF_SHADOW|TI_TF_HALIGN_CENTER );
  mpCtrl->DrawTextBox( sNames[mSelection], margin, 2, tbWidth, 1, TiUIControl::kNormal, TI_TF_SHADOW );
  mpCtrl->DrawTextBox( sDescriptions[mSelection], margin, 4, tbWidth, rows-4, TiUIControl::kNormal, TI_TF_SHADOW|TI_TF_ELLIPSIS );
}

//***********************************************************************
// ProcessButtonDown
//***********************************************************************

bool TiClassWindow::ProcessButtonDown( int32 DeviceId, int32 ButtonId )
{
  switch( TiWindow::GetButton( ButtonId ) )
  {
  case TiButtonMap::kLeft:
    mSelection--;
    return( true );

  case TiButtonMap::kRight:
    mSelection++;
    return( true );

  case TiButtonMap::kX:
    Select();
    return( true );

  case TiButtonMap::kCircle:
    CloseWindow();
    return( true );

  default:
    return( TiWindow::ProcessButtonDown( DeviceId, ButtonId ) );
  }
}

//***********************************************************************
// ProcessMessage
//***********************************************************************

void TiClassWindow::ProcessMessage( TiWindowMessage* pMessage )
{
  switch( pMessage->GetMessageId() )
  {
  case TIWINDOW_SETFOCUS:
    {
      // just gained focus
      TiFocusMessage* pMsg = static_cast<TiFocusMessage*>(pMessage);
      TiWindow* pOld = pMsg->GetOldWindow();
      //TiWindow* pNew = pMsg->GetNewWindow();

      if( pOld == mpParent )
      {
        mSelection = 0;
        mpCtrl->Close( true );
        mpCtrl->Open();

        mpButtons->Close( true );
        mpButtons->Open();
      }
      return;
    }

  default:
    TiWindow::ProcessMessage( pMessage );
    return;
  }
}

//***********************************************************************
// Select
//***********************************************************************

void TiClassWindow::Select()
{
  TiCharacterCreateMessage msg( this, TI_CREATE_CLASS );
  msg.SetClass( mSelection );
  ProcessMessage( &msg );
}
