/********************************************************************

  Module: TiCommandMessage

  Author: Carlo Ordonez

  Description:

    Command Message

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiCommandMessage_h_
#define _TiCommandMessage_h_

#include "TiWindowMessage.h"

static const uint16 TI_CMD_UNUSED0001     = 0x0001;
static const uint16 TI_CMD_UNUSED0002     = 0x0002;
static const uint16 TI_CMD_UNUSED0003     = 0x0003;
static const uint16 TI_CMD_UNUSED0004     = 0x0004;
static const uint16 TI_CMD_UNUSED0005     = 0x0005;
static const uint16 TI_CMD_UNUSED0006     = 0x0006;
static const uint16 TI_CMD_GOD_MODE       = 0x0007;
static const uint16 TI_CMD_INVISIBLE      = 0x0008;
static const uint16 TI_CMD_LOG            = 0x0009;
static const uint16 TI_CMD_DEBUG_LABEL    = 0x000a;
static const uint16 TI_CMD_RESTART        = 0x000b; 
static const uint16 TI_CMD_BLOOM          = 0x000c;
static const uint16 TI_CMD_WATERONSPU     = 0x000d;
static const uint16 TI_CMD_MULTI_PASS     = 0x000e;
static const uint16 TI_CMD_DISPLAY_STATS  = 0x000f;
static const uint16 TI_CMD_NORMAL         = 0x0010;
static const uint16 TI_CMD_WIRE_FRAME     = 0x0011;
static const uint16 TI_CMD_SOLID_FILL     = 0x0012;
static const uint16 TI_CMD_BUILD_INFO     = 0x0013;
static const uint16 TI_CMD_VINCE          = 0x0014;
static const uint16 TI_CMD_MONO           = 0x0015;
static const uint16 TI_CMD_STEREO         = 0x0016;
static const uint16 TI_CMD_5_1_SURROUND   = 0x0017;
static const uint16 TI_CMD_7_1_SURROUND   = 0x0018;
static const uint16 TI_CMD_RETURN_TO_GAME = 0x0019;
static const uint16 TI_CMD_USE_GATE_SCROLL = 0x001a;
static const uint16 TI_CMD_LOAD_GAME      = 0x001b;
static const uint16 TI_CMD_OPTIONS        = 0x001c;
static const uint16 TI_CMD_EXIT_GAME      = 0x001d;
static const uint16 TI_CMD_START          = 0x001e;
static const uint16 TI_CMD_GOTO_LEVEL     = 0x001f;
static const uint16 TI_CMD_EXIT_TITAN     = 0x0020;
static const uint16 TI_CMD_TOGGLE_SHADOW  = 0x0021;
static const uint16 TI_CMD_TOGGLE_PORTALS = 0x0022;
static const uint16 TI_CMD_TOGGLE_FLORA   = 0x0023;
static const uint16 TI_CMD_TOGGLE_PARTICLES = 0x0024;
static const uint16 TI_CMD_SAVE_GAME      = 0x0025;

class TiCommandMessage : public TiWindowMessage
{
public:
  TiCommandMessage( TiWindow* pSender, int32 MessageId, int32 CommandId, bool Checked )
    : TiWindowMessage( pSender, MessageId )
  {
    mCommandId = CommandId;
    mChecked = Checked;
    mClose = true;
    mString.Init("");
  }
  ~TiCommandMessage() {}

  int32 GetCommandId() const { return( mCommandId ); }
  bool  IsChecked() const { return( mChecked ); }

  bool  GetClose() const { return( mClose ); }
  void  SetClose( bool Close ) { mClose = Close; }

  const SyString& GetCommandString() const { return( mString ); }
  void            SetCommandString( const SyString& String ) { mString = String; }

private:

  int32     mCommandId;
  bool      mChecked;
  bool      mClose;
  SyString  mString;
};

#endif

