/********************************************************************

Module: TiConsoleWindow

Author: Jon Wiesman

Description:

This window accepts text input and does command processing.

Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiConsoleWindow_h_
#define _TiConsoleWindow_h_

#include "TiWindow.h"
#include "TiBoxDraw.h"
#include "TiFont.h"
#include "SyString.h"
#include "SyVector.h"
#include <list>

class TitanI;

class TiConsoleCommandHandler
{
protected:
  static TitanI *sm_pTitanI;

  static void   RegisterHandler(TiConsoleCommandHandler *pHandler);
  static void   UnregisterHandler(TiConsoleCommandHandler *pHandler);

public:
  TiConsoleCommandHandler();
  virtual ~TiConsoleCommandHandler();


  virtual void  ProcessConsoleCommand(const SyString &str) {}

  static bool   IsWhiteSpace(char8 ch);
  static int32  TokenizeString(const SyString &str, SyVector<SyString> &arStrings);

  static void   SetTitanInterface(TitanI *pTitan) {sm_pTitanI = pTitan;}
  static std::list<TiConsoleCommandHandler*> &GetHandlerList();
};


class TiConsoleWindow : public TiWindow
{
  enum 
  {
    CW_MaxHistoryLines = 20,
  };

  TiBoxDraw                 m_bdFrame;
  std::list<SyString>       m_listHistory;
  std::list<SyString>::iterator m_itrHistory;
  SyString                  m_strText;
  bool                      m_bShift;
  int32                     m_iHScroll;
  int32                     m_iInsertionPoint;

  static TiConsoleWindow    *sm_pInstance;

  void                      CursorLeft();
  void                      CursorRight();
  void                      Delete();
  void                      OnEnter();
  void                      ArrowUp();
  void                      ArrowDown();
  void                      Backspace();
  void                      Home();
  void                      End();
  void                      ProcessConsoleCommand(const SyString &str);

public:
  TiConsoleWindow(TiApp* pApp, TitanI *pTitan);
  ~TiConsoleWindow();

  virtual bool      ProcessKeyDown(int32 nKeyCode);
  virtual bool      ProcessKeyUp(int32 nKeyCode );
  virtual void      DrawSelf();

  static TiConsoleWindow  *Instance() {return sm_pInstance;}
};

#endif

