/********************************************************************

  Module: TiEnhancementsWindow

  Author: Jon Wiesman

  Description:

    Enhancements window 

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiEnhancementsWindow_h_
#define _TiEnhancementsWindow_h_

#include "TiCharacterPage.h"
#include "TiChildFrameDraw.h"

class TiCharacterData;


class TiEnhancementsWindow : public TiCharacterPage
{
public:
  TiEnhancementsWindow( TiWindow* pParent, TiCharacterData* pData, int32 PlayerId );
  ~TiEnhancementsWindow();

  // overrides
  virtual int32     Init();
  virtual void      DrawSelf();
  virtual bool      ProcessKeyDown( int32 KeyCode );
  virtual bool      ProcessKeyUp( int32 KeyCode ) { return( false ); }
  virtual bool      ProcessButtonDown( int32 DeviceId, int32 ButtonId );
  virtual bool      ProcessButtonUp( int32 DeviceId, int32 ButtonId ) { return( false ); }
  virtual void      ProcessMessage( TiWindowMessage* pMessage );

private:

  void    OnGridUp();
  void    OnGridDown();
  void    OnGridLeft();
  void    OnGridRight();
  void    OnSlotLeft();
  void    OnSlotRight();
  void    OnSlotDown();
  bool    UseEnhancement( bool bConfirmed );
  void    OnSelectGrid();
  void    OnSelectSlot();

  enum 
  {
    EW_EnhancementSlots = 4,
    EW_EnhancementGridWidth = 6,
    EW_EnhancementGridHeight = 5,
  };

  enum EWMode
  {
    EWMode_BrowsingSlots,       // we are moving between slots (down goes to browsing grid)
    EWMode_BrowsingGrid,        // we are moving between grids (up in top row goes to browsing slots)
    EWMode_SelectingSlot,       // we've selected a grid enhancement and are selecting a slot
    EWMode_SelectingGrid,       // we've selected a slot and are selecting a grid enhancement
	EWMode_ConfirmingSlot,		// we've selected a valid slot, now we're doing final confirmation before adding the enhancement
	EWMode_ConfirmingGrid,		// we've selected a valid grid enhancement, now we're doing final confirmation before adding the enhancement
  };
  EWMode            m_eMode;
  int               m_iSlot;      // current enhancement slot
  TiPoint           m_ptCurrent;  // current grid square
  int32				m_iEnhancementToRemove;	// enhancement that will be removed

  TiChildFrameDraw  m_cfdGrid;
  TiBoxDraw         m_bdActive;
  TiSprite          m_sprEnhancementSlots;

};

#endif

