/********************************************************************

  Module: TiEquipWindow

  Author: Carlo Ordonez

  Description:

    Equip window (displays equippable items)

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiEquipWindow_h_
#define _TiEquipWindow_h_

#include "TiCharacterPage.h"
#include "TiSprite.h"
#include "TiBoxDraw.h"
#include "TiChildFrameDraw.h"

class TiUIControl;
class TiUILayout;
class TiCharacterData;
class TiCharacterItemInfo ;
class TiCharacterData;
class Titan;
class TitanUI;
class SyScene;

enum 
{
  EW_MaxEquipSlots = 6,
};


class TiEquipWindow : public TiCharacterPage
{
public:
  TiEquipWindow( TiWindow* pParent, TiCharacterData* pData, int32 PlayerId );
  ~TiEquipWindow();

  // overrides
  virtual int32     Init();
  virtual void      DrawSelf();
  virtual bool      ProcessKeyDown( int32 KeyCode );
  virtual bool      ProcessKeyUp( int32 KeyCode ) { return( false ); }
  virtual bool      ProcessButtonDown( int32 DeviceId, int32 ButtonId );
  virtual bool      ProcessButtonUp( int32 DeviceId, int32 ButtonId ) { return( false ); }
  virtual void      ProcessReloadLayout();

  void              SetPaperDollSpriteHandle (int32 paperDoll);

private:
  void              DrawPersonaTabs();
  void              Debug_AddItems();
  int32             GetIndexForSlotEnum( int iSlotEnum ) const;


  void              InitSlotIcons();
  void              UpdateEquipItemList();
  void              UpdatePaperDoll(int32 itemSpriteHandle);
  void              DrawSlot( const char8* pSlot, bool Selected );
  void              DrawSlots();
  void              DrawCurrent();
  void              DrawEquipment();
  void              ItemActivate();
  void              ItemDrop();

  void              Next();
  void              Prev();
  void              Drop();
  bool              Back();
  void              Select();
  int32             GetPlayerSprite (int iPlayer);
  
  const TiCharacterItemInfo *GetEquippedItem(int32 iSlot) const;

  bool              m_bEquipMode;     // if true, we are scrolling through valid equipment. otherwise, we are selecting a slot
  int32             m_iSlot;
  int32             m_iItem;
  TiSprite          m_sprEquipIcons[EW_MaxEquipSlots];
  TiChildFrameDraw  m_cfd;

  int32             mPaperDollSpriteHandle;
};

#endif

