/******************************************************************

  Module: TiFont.h

  Author: Jon Wiesman

  Description:

    2D Font class

  Copyright 2004 Sony Online Entertainment.  All rights reserved.

*******************************************************************/

#ifndef __TiFont_h__
#define __TiFont_h__

#include "TiPtSizeRect.h"
#include "SyString.h"
#include "SyColor.h"
#include "TiSprite.h"

// flags for text methods
#define TI_TF_LEFT                  0
#define TI_TF_SHADOW                (1<<0)    // draw text shadow
#define TI_TF_ELLIPSIS              (1<<1)    // print ellipses if text doesn't fit within box
#define TI_TF_HALIGN_CENTER         (1<<2)    // center horiz. within bounds
#define TI_TF_HALIGN_RIGHT          (1<<3)    // right justify within bounds
#define TI_TF_HARD_BREAK            (1<<4)    // break line at last possible character, not at last 'space' character; probably only useful for single-line text
#define TI_TF_FRAME                 (1<<5)    // draw frame around a text box
#define TI_TF_CALCONLY              (1<<6)    // just calculates the height and returns it
#define TI_TF_VCENTER               (1<<7)    // Crazy!
#define TI_TF_GLOW                  (1<<8)    // the HELL you say!
#define TI_TF_LINE_OFFSET(x)        ((x)<<24) // for multi-line textboxes, scroll down x lines


class TiFont 
{
    enum EControllerChars
    {
      CC_Triangle,
      CC_Square,
      CC_Circle,
      CC_X,
      CC_Start,
      CC_Select,
      CC_L1,
      CC_L2,
      CC_R1,
      CC_R2,
      CC_North,
      CC_South,
      CC_West,
      CC_East,

      CC_Max,

    };
    int32               m_nFontHandle;
    int32               m_nHeight;
    
    TiSprite            m_sprControllerChars[CC_Max];

    void                AppendEllipsis( char8* pszText, int32 MaxWidth ) const;
    int32                 DrawTextInternal( const char8* pText, TiPoint pt, const SyColor32F& Color, uint32 uFlags) const;
    const TiSprite      *GetSpriteForChar(const char8 ch) const;

    int32                 TheRealDraw(const char8 *pszString, TiRect rect, SyColor32F color,
                                    uint32 uFlags) const;

public:
    enum 
    {
        FD_LEFT =       0x0000,
        FD_RIGHT =      0x0001,
        FD_CENTER =     0x0002,
        FD_MULTILINE =  0x0004,
        FD_CALCONLY =   0x0008,
    };

public:
    TiFont(int32 nFontHandle);

    int32                 Draw(const char8 *pszString, TiRect rect, SyColor32F color,
                                 uint32 uFlags) const;
    
    int32                 Draw(const SyString &str, TiRect rect, SyColor32F color,
                                 uint32 uFlags) const;
    
    int32                 GetHeight() const {return m_nHeight;}
    int32                 GetTextWidth(const char8 *pszString) const;
    int32                 GetWrappedTextHeight(const char8 *psz, TiRect rect, uint32 uFlags) const;
    int32                 GetWrappedTextHeight(const SyString& str, TiRect rect, uint32 uFlags) const;


    static bool         IsLeftAligned(uint32 uFlags) 
    {
        return ((uFlags & (FD_RIGHT | FD_CENTER)) == 0);
    }
    static bool         IsRightAligned(uint32 uFlags)
    {
        // center flag takes precedence
        return ((uFlags & (FD_RIGHT | FD_CENTER)) == FD_RIGHT);
    }
    static bool         IsCenterAligned(uint32 uFlags)
    {
        // center flag takes precedence
        return ((uFlags & FD_CENTER) != 0);
    }
};


#endif

