/********************************************************************

  Module: TiGameWindow

  Author: Carlo Ordonez

  Description:

    Game UI window

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiGameWindow_h_
#define _TiGameWindow_h_

#include "TiTopLevelWindow.h"
#include "TiSprite.h"
#include "TiCircleDraw.h"
#include "TiMiniMap.h"

class TiPauseMenu;
class TiCharacterWindow;
class TiCharacterData;
class TiCommandMessage;
class TitanUII;
class TitanI;
class TiActivateWindow;
class TiPawnOutput;
class TiPawnDebug;
class TiUILayout;

class TiGameWindow : public TiTopLevelWindow
{
public:
  // constructor/destructor
  TiGameWindow( TiApp* pApp, TitanUII *pTitanUI, TitanI *pTitan );
  ~TiGameWindow();

  // overrides
  virtual void    DrawSelf();
  virtual bool    ProcessKeyDown( int32 KeyCode );
  virtual bool    ProcessButtonDown( int32 DeviceId, int32 Button );
  virtual void    ProcessMessage( TiWindowMessage* pMessage );
  virtual void    ProcessReloadLayout();

  // properties
  int32           GetPlayerCount() const { return( mPlayerCount ); }
  void            SetPlayerCount( int32 Count );
  void            SetHealth( int32 Player, int32 Health );
  void            SetHealthMax( int32 Player, int32 HealthMax );
  void            SetMana( int32 Player, int32 Mana );
  void            SetManaMax( int32 Player, int32 ManaMax );
  void            SetExperience( int32 Player, int32 Experience );
  void            SetExperienceMax( int32 Player, int32 ExperienceMax );
  void            SetLevel( int32 Player, int32 Level );
  void            SetName( int32 Player, const char8* pName );
  void            SetActivateText( int32 Player, const char8* pText );
  void            SetSubtitleText( const char8* pText );
  void            SetTitan( TitanUII* pTitanUI, TitanI* pTitan ) { mpTitanUI = pTitanUI; mpTitan = pTitan; }
  void            SetMinimap(const SyString&  textureName,
                             const SyVect2&   worldPos1,
                             const SyVect2&   worldPos2,
                             const SyVect2&   mapPos1,
                             const SyVect2&   mapPos2,
                             SyRaster*        raster,
                             SyDictionary*    dictionary);
  TiMiniMap&      GetMinimap() { return m_MiniMap; }

  void            DrawCharacterHud(int iCharacter, float fHealth, float fMana, float fExp);

  // for debugging
  void            TogglePawnOutput();
  void            PawnDebugOutput( const char8* pText );
  int             PawnDebugUI( const char8* pSource, int32 LineNum, const char8* pVariables );
  void			  UpdateCharacterData();

private:

  void            OpenCharacterWindow( int32 Player );
  void            OpenPauseMenu( int32 Player );

  // for heads-up display
  static const int32 PLAYER_MAX = 4;
  class Stats
  {
  public:
    int32   mHealth;
    int32   mHealthMax;
    int32   mMana;
    int32   mManaMax;
    int32   mXP;
    int32   mXPMax;
    int32   mLevel;
    char8   mName[32];

    int32   mPrevHealth;
    int32   mPrevMana;

    bool    mHit;
    bool    mPrevHit;
  };

  Stats               mPlayerStats[ PLAYER_MAX ];
  int32               mPlayerCount;

  TiSprite            m_sprExpFrame;
  TiSprite            m_sprCharacterFrame;
  TiSprite            m_sprHealthBar;
  TiSprite            m_sprManaBar;
  TiSprite            m_sprPortraits[ PLAYER_MAX ];
  TiCircleDraw        m_cdExpBars[ PLAYER_MAX ];
  TiMiniMap           m_MiniMap;

  TiPauseMenu*        mpPauseMenu;
  TiCharacterWindow*  mpCharacterWindow;
  TiCharacterData*    mpCharacterData;
  TiActivateWindow*   mpActivateWindow;
  TiPawnOutput*       mpPawnOutput;
  TiPawnDebug*        mpPawnDebug;

  TiUILayout*         mpNPCLayout;
  TiUILayout*         mpPlayerLayout;

  // This is here so that the game window has some sense of who its parent is;
  // If TitanUI was a window-type object, we could remove this (ideally);
  // Alternatively, we could replace it with a client sub-object
  TitanI*             mpTitan;
  TitanUII*           mpTitanUI;
};

#endif

