/********************************************************************

  Module: TiListView

  Author: Carlo Ordonez

  Description:

    Titan list view base class

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#include "TiListView.h"

IMPLEMENT_CLASS( TiListView, wxListView )

BEGIN_EVENT_TABLE( TiListView, wxListView )
END_EVENT_TABLE()

//***********************************************************************
// Constructor
//***********************************************************************

TiListView::TiListView( wxWindow* pParent, int WindowId, long Style )
: wxListView( pParent, WindowId, wxDefaultPosition, wxDefaultSize, Style )
{
}

//***********************************************************************
// Next
//***********************************************************************

void TiListView::Next()
{
  int count = GetItemCount();
  long sel = GetFirstSelected();
  if( sel >= 0 && sel+1 < count )
  {
    Select( sel+1 );
    EnsureVisible( sel+1 );
  }
  else if( sel >= count-1 && count > 0 )
  {
    Select( 0 );
    EnsureVisible( 0 );
  }
}

//***********************************************************************
// Prev
//***********************************************************************

void TiListView::Prev()
{
  int count = GetItemCount();
  long sel = GetFirstSelected();
  if( sel > 0 && count > 1 )
  {
    Select( sel-1 );
    EnsureVisible( sel-1 );
  }
  else if( sel <= 0 && count > 1 )
  {
    Select( count-1 );
    EnsureVisible( count-1 );
  }
}
