/********************************************************************

Module: TiMiniMap

Author: Matt Stelzer

Description:

Mini map

Copyright 2006 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef __TIMINIMAP_H__
#define __TIMINIMAP_H__

#include "SyString.h"
#include "SyRaster.h"
#include "TiSprite.h"

class TiMiniMap
{
public:
  TiMiniMap();

public:
  void Init(const SyString&  mapBaseName,
            const SyVect2&   worldPos1,
            const SyVect2&   worldPos2,
            const SyVect2&   mapPos1,
            const SyVect2&   mapPos2,
            SyRaster*        raster,
            SyDictionary*    dictionary);
  void Update(const SyVect3& pos, float heading);
  void Draw() const;

private:
  void CalculateMapToWorldTransform(const SyVect2& worldPos1,
                                    const SyVect2& worldPos2,
                                    const SyVect2& mapPos1,
                                    const SyVect2& mapPos2);
  void CalculateMapTextureTransform(SyMatrix33& mat) const;

private:
  SyRaster*             mRaster;
  TiSprite              mCompassSprite;
  int32                 mMaskSurfaceHandle;
  int32                 mMapSurfaceHandle;
  SyVect2               mPlayerPos;
  float                 mHeading;
  SyVect2               mOffset;
  SyVect2               mScale;
  float                 mZoom;
};

#endif // __TIMINIMAP_H__


