/********************************************************************

  Module: TiNameWindow

  Author: Carlo Ordonez

  Description:

    Panel for naming your new character

  Copyright 2006 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#include "TiNameWindow.h"
#include "TiKeyboard.h"
#include "TiUIControl.h"
#include "TiUI.h"
#include "TiFocusMessage.h"
#include "TiCharacterCreateMessage.h"

//***********************************************************************
// Constructor/Destructor
//***********************************************************************

TiNameWindow::TiNameWindow( TiWindow* pParent )
: TiWindow( pParent )
{
  mpCtrl = SyNew TiUIControl();

  mpKeyboard = SyNew TiKeyboard( this );
  mpKeyboard->SetTitle( "Character Name" );
  mpKeyboard->SetMaxLen( 16 );
}

TiNameWindow::~TiNameWindow()
{
  delete mpCtrl;
}

//***********************************************************************
// DrawSelf
//***********************************************************************

void TiNameWindow::DrawSelf()
{
  int32 w, h;
  TiUI::Instance()->GetDisplaySize( &w, &h );

  int32 width = mpCtrl->GetTextWidth( "|cBack" ) + 40;
  mpCtrl->Init( SyVect2I(w>>1, h-125), width, 1, TiUIControl::kBlack );
  mpCtrl->Draw();
  mpCtrl->DrawTextBox( "|cBack", 20, 0, width-40, 1, TiUIControl::kNormal, TI_TF_HALIGN_CENTER|TI_TF_SHADOW );
}

//***********************************************************************
// ProcessMessage
//***********************************************************************

void TiNameWindow::ProcessMessage( TiWindowMessage* pMessage )
{
  switch( pMessage->GetMessageId() )
  {
  case TIWINDOW_SETFOCUS:
    mpCtrl->Close( true );
    mpCtrl->Open();
    mpKeyboard->SetFocus();
    return;

  case TIWINDOW_CLOSE:
    {
      TiWindowMessage msg( this, TIWINDOW_CLOSE );
      mpParent->ProcessMessage( &msg );
    }
    return;

  case TIWINDOW_KB_ACCEPT:
    {
      TiCharacterCreateMessage msg( this, TI_CREATE_NAME );
      msg.SetName( SyString( mpKeyboard->GetText() ) );
      ProcessMessage( &msg );
    }
    return;

  default:
    TiWindow::ProcessMessage( pMessage );
    return;
  }
}
