/********************************************************************

  Module: TiNewCharacterWindow

  Author: Carlo Ordonez

  Description:

    Character Creation Window

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#include "TiNewCharacterWindow.h"
#include "TiClassWindow.h"
#include "TiAppearanceWindow.h"
#include "TiAttributeWindow.h"
#include "TiNameWindow.h"
#include "TiWindowEvent.h"

IMPLEMENT_CLASS( TiNewCharacterWindow, TiWindow )

BEGIN_EVENT_TABLE( TiNewCharacterWindow, TiWindow )
EVT_KEY_DOWN( TiNewCharacterWindow::OnKeyDown )
EVT_SIZE( TiNewCharacterWindow::OnSize )
EVT_ERASE_BACKGROUND( TiNewCharacterWindow::OnEraseBackground )
EVT_SET_FOCUS( TiNewCharacterWindow::OnSetFocus )
END_EVENT_TABLE()

//***********************************************************************
// Constructor
//***********************************************************************

TiNewCharacterWindow::TiNewCharacterWindow( wxWindow* pParent, TitanI* pTitan, int PlayerId, const wxString& Name, int WindowId )
: TiWindow( pParent, pTitan, PlayerId, Name, WindowId )
{
  mpClass = new TiClassWindow( this, pTitan, PlayerId );
  mpAppearance = new TiAppearanceWindow( this, pTitan, PlayerId );
  mpAttributes = new TiAttributeWindow( this, pTitan, PlayerId );
  mpName = new TiNameWindow( this, pTitan, PlayerId );

  int w, h;
  wxDisplaySize( &w, &h );
  mpClass->SetSize( w, h );
  mpAppearance->SetSize( w, h );
  mpAttributes->SetSize( w, h );
  mpName->SetSize( w, h );

  mpClass->SetPosition( wxPoint(50,50) );
  mpAppearance->SetPosition( wxPoint(50,50) );
  mpAttributes->SetPosition( wxPoint(50,50) );
  mpName->SetPosition( wxPoint(50,50) );

  SetMode( kClass );
}

//***********************************************************************
// Destructor
//***********************************************************************

TiNewCharacterWindow::~TiNewCharacterWindow()
{
  mpClass->Destroy();
  mpAppearance->Destroy();
  mpAttributes->Destroy();
  mpName->Destroy();
}

//***********************************************************************
// Back
//***********************************************************************

void TiNewCharacterWindow::Back()
{
  switch( mMode )
  {
  case kClass:
    {
      TiWindowEvent event( TIWINDOW_CLOSE, GetId() );
      ProcessEvent( event );
    }
    break;

  case kAppearance:
    SetMode( kClass );
    break;

  case kAttributes:
    SetMode( kAppearance );
    break;

  case kName:
    SetMode( kAttributes );
    break;
  }
}

//***********************************************************************
// Next
//***********************************************************************

void TiNewCharacterWindow::Next()
{
  switch( mMode )
  {
  case kClass:
    SetMode( kAppearance );
  	break;

  case kAppearance:
    SetMode( kAttributes );
    break;

  case kAttributes:
    SetMode( kName );
    break;

  case kName:
    // submit character
    break;
  }
}

//***********************************************************************
// SetMode
//***********************************************************************

void TiNewCharacterWindow::SetMode( Mode NewMode )
{
  mMode = NewMode;

  mpClass->Close();
  mpAppearance->Close();
  mpAttributes->Close();
  mpName->Close();

  switch( mMode )
  {
  case kClass:
    mpClass->Open();
    mpClass->SetFocus();
    break;

  case kAppearance:
    mpAppearance->Open();
    mpAppearance->SetFocus();
    break;

  case kAttributes:
    mpAttributes->Open();
    mpAttributes->SetFocus();
    break;

  case kName:
    mpName->Open();
    mpName->SetFocus();
    break;
  }
}

//***********************************************************************
// OnKeyDown
//***********************************************************************

void TiNewCharacterWindow::OnKeyDown( wxKeyEvent& event )
{
  switch( event.GetKeyCode() )
  {
  case WXK_ESCAPE:
    Back();    
  	return;

  case WXK_RETURN:
    Next();
    return;
  }

  event.Skip();
}

//***********************************************************************
// OnSize
//***********************************************************************

void TiNewCharacterWindow::OnSize( wxSizeEvent& event )
{
  Layout();
}

//***********************************************************************
// OnPaint
//***********************************************************************

void TiNewCharacterWindow::OnPaint( wxPaintEvent& event )
{
  wxPaintDC dc( this );

  /*
  PrepareDC( dc );
  dc.BeginDrawing();
  dc.SetPen( *wxGREEN_PEN );
  dc.SetBrush( *wxTRANSPARENT_BRUSH );
  dc.DrawRectangle( GetClientRect() );
  dc.EndDrawing();
  //*/
}

//***********************************************************************
// OnEraseBackground
//***********************************************************************

void TiNewCharacterWindow::OnEraseBackground( wxEraseEvent& event )
{
}

//***********************************************************************
// OnSetFocus
//***********************************************************************

void TiNewCharacterWindow::OnSetFocus( wxFocusEvent& event )
{
  SetMode( mMode );
}

