/********************************************************************

  Module: TiOptionsWindow

  Author: Carlo Ordonez

  Description:

    Adjust various game settings

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiOptionsWindow_h_
#define _TiOptionsWindow_h_

#include "TiWindow.h"
#include "SyString.h"
#include "SyArray.h"

class TiUIControl;
class TitanOptionsI;
class TiOptionsWindow : public TiWindow
{
public:
  TiOptionsWindow( TiWindow* pParent );
  ~TiOptionsWindow();

  void                SetOptions( TitanOptionsI* pOptions );

  // overrides
  virtual void        DrawSelf();
  virtual bool        ProcessKeyDown( int32 KeyCode );
  virtual bool        ProcessButtonDown( int32 DeviceId, int32 ButtonId );
  virtual void        ProcessMessage( TiWindowMessage* pMessage );

private:

  void                Select();
  void                Left();
  void                Right();
  void                Close();

private:

  class Option
  {
  public:
    enum Type
    {
      kTypeToggle,
      kTypeSlider,
      kTypeCommand,
    };

    Option();
    Option( const char8* pName, Type type=kTypeToggle, float32 SliderVal=0.f, bool ToggleVal=false);

    SyString  mName;
    Type      mType;
    float32   mSliderVal;
    bool      mToggleVal;
  };

  enum Options
  {
    kOptBrightness,
    kOptAmbVol,
    kOptFxVol,
    kOptControls,
    kOptSwivel,
    kOptReverseCamera,
    kOptVibration,
    kOptStereo,
    kOptBlood,
    kOptSubtitles,
    kOptDamageText,
    kOptChatText,
    kOptPlayerMarkers,
    kOptHeadset,

    kOptMax
  };

  TiUIControl*        mpCtrl;
  SyArray< Option >   mOptions;
  int32               mSelection;

  TitanOptionsI*      mpOptions;
  bool                mDisplayControls;
};

#endif

