/********************************************************************

  Module: TiPauseMenu

  Author: Carlo Ordonez

  Description:

    Menu that pops up when Start is pressed

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiPauseMenu_h_
#define _TiPauseMenu_h_

#include "TiWindow.h"
#include "TiMenu.h"
#include "SyVector.h"

class TitanOptionsI;
class TiLoadSaveGameWindow;
class TiOptionsWindow;
class TiUIControl;

class TiPauseMenu : public TiWindow
{
public:
  TiPauseMenu( TiWindow* pParent );
  ~TiPauseMenu();

  int32           Init( int32 Player, TitanOptionsI* pOptions );

  void            SetCheck( int32 MenuItemId, bool Check );
  bool            GetCheck( int32 MenuItemId ) const;

  // overrides
  virtual void    DrawSelf();
  virtual bool    ProcessKeyDown( int32 KeyCode );
  virtual bool    ProcessButtonDown( int32 DeviceId, int32 ButtonId );
  virtual void    ProcessMessage( TiWindowMessage* pMessage );
  virtual bool    IsVisible() const;
  virtual void    Show( bool Visible );

private:

  void            Next();
  void            Prev();
  void            Select();
  void            Back();
  void            OpenOptionsWindow();
  void            CloseOptionsWindow();

private:

  static const int32 Wnd_Width = 250;
  static const int32 Wnd_Rows = 10;

  TiUIControl*      mpCtrl;
  TiMenu*           mpCurrentMenu;
  int32             mPlayerId; // who has me open?
  bool              mInitialized;

  TiMenu            mMenu;
  TiMenu            mTestMenu;
  TiMenu            mDesignMenu;
  TiMenu            mRenderMenu;
  TiMenu            mSoundMenu;
  TiMenu            mProgrammingMenu;
  TiMenu            mDrawModeMenu;
  TiMenu            mLevelMenu;

  SyVector<TiMenu*> mMenus;

  TiOptionsWindow*		mpOptionsWindow;
  TiLoadSaveGameWindow*	mpLoadSaveGameWindow;
};

#endif

