/********************************************************************

  Module: TiPawnDebug

  Author: Carlo Ordonez

  Description:

    Pawn debugger UI

  Copyright 2006 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiPawnDebug_h_
#define _TiPawnDebug_h_

#include "TiDialog.h"
#include "SyString.h"
#include "SyVector.h"

class TiUIControl;
class TiPawnDebug : public TiDialog
{
public:
  TiPawnDebug( TiWindow* pParent );
  ~TiPawnDebug();

  void              SetSource( const char8* pSource, int32 LineNum );
  void              SetVariables( const char8* pVariables );

  virtual void      DrawSelf();
  virtual bool      ProcessButtonDown( int32 DeviceId, int32 ButtonId );
  virtual bool      ProcessKeyDown( int32 KeyCode );
  virtual void      ProcessMessage( TiWindowMessage* pMessage );

private:

  enum Command
  {
    kRun = 0,
    kStep = 1,
    kDebugOff = 2
  };
  void                  AddLine( SyString& Line );

  TiUIControl*          mpCtrl;

  SyString              mVariables;
  SyString              mSource;

  SyVector< SyString >  mLines;
  int32                 mLineNum;
  int32                 mScroll;
};

#endif

