/********************************************************************

  Module: TiQuestWindow

  Author: Carlo Ordonez

  Description:

    Quest Journal Window

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#include "TiQuestWindow.h"
#include "TiUI.h"
#include "TiCharacterData.h"
#include "TiFont.h"

static TiRect c_rectOuterFrame(TiPoint(12, 4), TiSize(457, 618));
static TiRect c_rectTitlebar(TiPoint(28, 11), TiSize(425, 27));

//***********************************************************************
// Constructor/Destructor
//***********************************************************************

TiQuestWindow::TiQuestWindow( TiWindow* pParent, TiCharacterData* pData, int32 PlayerId )
: TiCharacterPage( pParent, pData, PlayerId, kQuests )
{
}

TiQuestWindow::~TiQuestWindow()
{
}

//***********************************************************************
// DrawSelf
//***********************************************************************

void TiQuestWindow::DrawSelf()
{
  DrawBackground();

  TiRect rectWindow = GetScreenRect();

  sm_bdFrame.DrawWithFill(c_rectOuterFrame + rectWindow.TopLeft(), c_crFrameFill);

  TiFont font(TiUI::Instance()->GetFontHandle("Default"));

  TiRect rect = c_rectTitlebar + rectWindow.TopLeft();
  char8 szBuffer[256] = "";
  static SyResourceID idEquipmentTabName = SyHashResourceID("UiQuestsTabName");

  m_pData->GetTitanInterface()->T4Expand(szBuffer, sizeof(szBuffer), idEquipmentTabName);
  font.Draw(szBuffer, c_rectTitlebar + GetScreenRect().TopLeft(), c_crWhite, TI_TF_SHADOW | TI_TF_HALIGN_CENTER);
}

//***********************************************************************
// ProcessKeyDown
//***********************************************************************

bool TiQuestWindow::ProcessKeyDown( int32 KeyCode )
{
  return( false );
}

//***********************************************************************
// ProcessButtonDown
//***********************************************************************

bool TiQuestWindow::ProcessButtonDown( int32 DeviceId, int32 ButtonId )
{
  if( DeviceId != m_iPlayer ) { return( false ); }

  return( false );
}

//***********************************************************************
// ProcessReloadLayout
//***********************************************************************

void TiQuestWindow::ProcessReloadLayout()
{
}
