/********************************************************************

  Module: TiSceneController

  Author: Carlo Ordonez

  Description:

    Scene control for front end

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiSceneController_h_
#define _TiSceneController_h_

#include "SySceneTypes.h"

class TitanUII;
class SyCamera;

class TiSceneController
{
public:
  TiSceneController();
  ~TiSceneController();

  int         Init( TitanUII* pUI, float32 ViewAngle, float32 AspectRatio );
  int         Reset();
  int         LoadScene( const char* pFilename );
  void        Render();
  void        GotoActor( int Index );

private:

  TitanUII*   mpTitanUI;
  SyCamera*   mpCamera;
  bool        mSceneLoaded;
  float32     mViewAngle;
  float32     mAspectRatio;
  
  SyActorHandle mhActors[3];
};

#endif

