/********************************************************************

  Module: TiSkillsWindow

  Author: Carlo Ordonez

  Description:

    Skills & Abilities Window

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiSkillsWindow_h_
#define _TiSkillsWindow_h_

#include "TiCharacterPage.h"
#include "TiChildFrameDraw.h"
#include "TiAbilityTree.h"
#include "TiSprite.h"

class TiCharacterData;
class TiSkillsWindow : public TiCharacterPage
{
public:
  TiSkillsWindow( TiWindow* pParent, TiCharacterData* pData, int32 PlayerId );
  ~TiSkillsWindow();

  enum NavMode
  {
    kCurrent,
    kAvailable
  };
  enum FaceButton
  { 
    kX        = 0,
    kSquare   = 1,
    kTriangle = 2,
    kCircle   = 3,

    kButtonsToMap,
  };

  // overrides
  virtual int32     Init();
  virtual void      DrawSelf();
  virtual bool      ProcessKeyDown( int32 KeyCode );
  virtual bool      ProcessKeyUp( int32 KeyCode );
  virtual bool      ProcessButtonDown( int32 DeviceId, int32 ButtonId );
  virtual bool      ProcessButtonUp( int32 DeviceId, int32 ButtonId );
  virtual void      ProcessReloadLayout();
  virtual void      OnProcessFrame();

private:

  void              DrawCurrent();
  void              DrawAvailable();
  void              DrawMap();

  void              AbilityMap( FaceButton Button );
  void              AbilityBuy();

  void              TreeDown();
  void              TreeUp();
  void              TreeLeft();
  void              TreeRight();
  void              Select();
  bool              Back();
  void              BeginMap();
  void              TryMap( FaceButton Button );
  void              EndMap();


  void              DetermineMaxScrollY();

  TiAbilityTree     m_tree;

  TiSprite          m_sprNode;
  TiSprite          m_sprVertBar;
  TiSprite          m_sprHorzBar;
  TiSprite          m_sprToLeft;
  TiSprite          m_sprToRight;
  TiSprite          m_sprFromLeft;
  TiSprite          m_sprFromRight;
  TiChildFrameDraw  m_cfd;
  bool              m_bMapping;
  bool              m_bLevelingUp;
  TiPoint           m_ptCurrent;
  int32             m_nMaxRow;
  TiSprite          m_sprSkills[c_nMaxATCols * c_nMaxATRows];
  TiSprite          m_sprButtons[4];
  TiSprite          m_sprButtonSkills[4]; // the skills assigned to each button
  TiSprite          m_sprTier;
  TiSprite          m_sprRankCircle;
  TiSprite          m_sprSelectedNode;
  TiSprite          m_sprDamageNumbers[10];
  int32             m_iCurrentlyMappedButton;
};

#endif

