/********************************************************************

  Module: TiStartFrame

  Author: Carlo Ordonez

  Description:

    Start/Splash/Title screen

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#include "TiStartFrame.h"
#include "TiStartFrameEvent.h"
#include "TiMenu.h"
#include "TitanUI.h"
#include "TiSceneController.h"
#include "TiNewCharacterWindow.h"
#include "TiClassWindow.h"

IMPLEMENT_CLASS( TiStartFrame, wxFrame )

BEGIN_EVENT_TABLE( TiStartFrame, wxFrame )
EVT_KEY_DOWN( TiStartFrame::OnKeyDown )
EVT_JOY_BUTTON_DOWN( TiStartFrame::OnJoyButtonDown )
EVT_PAINT( TiStartFrame::OnPaint )
EVT_TIMER( ID_START_FRAME_TIMER, TiStartFrame::OnTimer )
EVT_ERASE_BACKGROUND( TiStartFrame::OnEraseBackground )
EVT_MENU( ID_START_FRAME_GO, TiStartFrame::Go_Click )
EVT_MENU( ID_START_FRAME_NEW, TiStartFrame::New_Click )
EVT_MENU( ID_START_FRAME_LOAD, TiStartFrame::Load_Click )
EVT_MENU( ID_START_FRAME_OPTIONS, TiStartFrame::Options_Click )
EVT_MENU( ID_START_FRAME_CREDITS, TiStartFrame::Credits_Click )
EVT_MENU( ID_START_FRAME_EASY1, TiStartFrame::Difficulty_Click )
EVT_MENU( ID_START_FRAME_MEDIUM1, TiStartFrame::Difficulty_Click )
EVT_MENU( ID_START_FRAME_HARD1, TiStartFrame::Difficulty_Click )
EVT_MENU( ID_START_FRAME_EXPERT1, TiStartFrame::Difficulty_Click )
EVT_MENU( ID_START_FRAME_EASY2, TiStartFrame::Difficulty_Click )
EVT_MENU( ID_START_FRAME_MEDIUM2, TiStartFrame::Difficulty_Click )
EVT_MENU( ID_START_FRAME_HARD2, TiStartFrame::Difficulty_Click )
EVT_MENU( ID_START_FRAME_EXPERT2, TiStartFrame::Difficulty_Click )
EVT_MENU( ID_START_FRAME_EASY3, TiStartFrame::Difficulty_Click )
EVT_MENU( ID_START_FRAME_MEDIUM3, TiStartFrame::Difficulty_Click )
EVT_MENU( ID_START_FRAME_HARD3, TiStartFrame::Difficulty_Click )
EVT_MENU( ID_START_FRAME_EXPERT3, TiStartFrame::Difficulty_Click )
EVT_MENU( ID_START_FRAME_EASY4, TiStartFrame::Difficulty_Click )
EVT_MENU( ID_START_FRAME_MEDIUM4, TiStartFrame::Difficulty_Click )
EVT_MENU( ID_START_FRAME_HARD4, TiStartFrame::Difficulty_Click )
EVT_MENU( ID_START_FRAME_EXPERT4, TiStartFrame::Difficulty_Click )
EVT_MENU( ID_START_FRAME_ARENA, TiStartFrame::Arena_Click )
EVT_MENU( ID_START_FRAME_INTERNET_GAME, TiStartFrame::Internet_Click )
EVT_TIWINDOW_CLOSE( ID_START_FRAME_MENU, TiStartFrame::Menu_Close )
EVT_TIWINDOW_CLOSE( ID_NEW_CHARACTER, TiStartFrame::NewCharacter_Close )
EVT_TIWINDOW_SELECT_CLASS( ID_WINDOW_CLASS, TiStartFrame::Class_Select )
END_EVENT_TABLE()

//***********************************************************************
// Constructor
//***********************************************************************

TiStartFrame::TiStartFrame( wxWindow* pParent, int WindowId, const wxString& Caption )
: wxFrame( pParent, WindowId, Caption, wxDefaultPosition, wxDefaultSize, wxNO_BORDER )
{
  SetOwnBackgroundColour( wxColour(0,0,0) );

  wxColour background(0,0,0);
  wxColour text(191,191,191);

  mpMenu = new TiMenu( this, (TitanI*)NULL, 0, _("Start"), ID_START_FRAME_MENU, background, text );
  mpMenu->Close( true );

  wxMenu* pCampaign[4];
  for( int i = 0; i < 4; i++ )
  {
    wxMenu* pDifficulty = new wxMenu();
    pDifficulty->Append( ID_START_FRAME_EASY1 + i, _("Adventurous"), _(""), wxITEM_NORMAL );
    pDifficulty->Append( ID_START_FRAME_MEDIUM1 + i, _("Courageous"), _(""), wxITEM_NORMAL );
    pDifficulty->Append( ID_START_FRAME_HARD1 + i, _("Champion"), _(""), wxITEM_NORMAL );
    pDifficulty->Append( ID_START_FRAME_EXPERT1 + i, _("Legendary"), _(""), wxITEM_NORMAL );

    pCampaign[i] = new wxMenu();
    pCampaign[i]->Append( ID_START_FRAME_CAMPAIGN, _("Campaign"), pDifficulty );
    pCampaign[i]->Append( ID_START_FRAME_ARENA, _("Arena"), _(""), wxITEM_NORMAL );
  }

  wxMenu* pPlayers = new wxMenu();
  pPlayers->Append( ID_START_FRAME_1PLAYER, _("1 Player"), pCampaign[0] );
  pPlayers->Append( ID_START_FRAME_2PLAYER, _("2 Players"), pCampaign[1] );
  pPlayers->Append( ID_START_FRAME_3PLAYER, _("3 Players"), pCampaign[2] );
  pPlayers->Append( ID_START_FRAME_4PLAYER, _("4 Players"), pCampaign[3] );

  wxMenu* pGame = new wxMenu();
  pGame->Append( ID_START_FRAME_NORMAL_GAME, _("Normal Game"), pPlayers );
  pGame->Append( ID_START_FRAME_INTERNET_GAME, _("Internet Game"), _(""), wxITEM_NORMAL );

  mpMenuStart = new wxMenu();
  mpMenuStart->Append( ID_START_FRAME_GO, _("Start Game NOW"), _(""), wxITEM_NORMAL );
  mpMenuStart->Append( ID_START_FRAME_NEW, _("Start New Game"), pGame );
  mpMenuStart->Append( ID_START_FRAME_LOAD, _("Load Game"), _(""), wxITEM_NORMAL );
  mpMenuStart->Append( ID_START_FRAME_OPTIONS, _("Options"), _(""), wxITEM_NORMAL );
  mpMenuStart->Append( ID_START_FRAME_CREDITS, _("Credits"), _(""), wxITEM_NORMAL );

  mpTitanUI = new TitanUI( this );
  mState = kEsrbLogo;
  mTimer.SetOwner( GetEventHandler(), ID_START_FRAME_TIMER );

  mpSceneControl = new TiSceneController();
  mpNewCharacter = NULL;
}

//***********************************************************************
// Destructor
//***********************************************************************

TiStartFrame::~TiStartFrame()
{
  mpMenu->Destroy();
  if( mpNewCharacter )
  {
    mpNewCharacter->Destroy();
  }
  delete mpMenuStart;
  delete mpTitanUI;
  delete mpSceneControl;
}

//***********************************************************************
// OnUpdateGame
//***********************************************************************

void TiStartFrame::OnUpdateGame()
{
}

//***********************************************************************
// OnRenderGame
//***********************************************************************

void TiStartFrame::OnRenderGame()
{
  mpSceneControl->Render();
}

//***********************************************************************
// NextState
//***********************************************************************

void TiStartFrame::NextState()
{
  switch( mState )
  {
  case kEsrbLogo:
    mState = kSOELogo;
    break;

  case kSOELogo:
    mState = kGameLogo;
    mpMenu->PopupMenu( mpMenuStart );
    mpMenu->Open( true ); // no fade-in
    LoadScene();
    break;

  case kGameLogo:
    mTimer.Stop();
    return;
  }

  mTimer.Stop();
  mTimer.Start( 5000 );
}

//***********************************************************************
// LoadScene
//***********************************************************************

void TiStartFrame::LoadScene()
{
  wxSize s = this->GetClientSize();
  mpSceneControl->Init( mpTitanUI, 55.f, (float32)s.GetWidth() / (float32)s.GetHeight() );

  // placeholder art
  mpSceneControl->LoadScene( "data\\art\\level\\arena.esf" );
}

//***********************************************************************
// OnKeyDown
//***********************************************************************

void TiStartFrame::OnKeyDown( wxKeyEvent& event )
{
  switch( event.GetKeyCode() )
  {
  case WXK_RETURN:
    if( mState != kGameLogo )
    {
      NextState();
    }
  	return;
  }

  event.Skip();
}

//***********************************************************************
// OnJoyButtonDown
//***********************************************************************

void TiStartFrame::OnJoyButtonDown( wxJoystickEvent& event )
{
  // default
  event.Skip();
}

//***********************************************************************
// OnPaint
//***********************************************************************

void TiStartFrame::OnPaint( wxPaintEvent& event )
{
  wxPaintDC dc( this );
  PrepareDC( dc );
  dc.BeginDrawing();
  {
    // get the image
    wxBitmap bmp;
    switch( mState )
    {
    case kEsrbLogo:
      bmp = wxBitmap( _("test/RP_AD.tga") );
      if( !mTimer.IsRunning() )
      {
        mTimer.Start( 8000 );
      }
    	break;

    case kSOELogo:
      bmp = wxBitmap( _("test/SOE_Logo.tga") );

      // override background color
      dc.SetPen( *wxWHITE_PEN );
      dc.SetBrush( *wxWHITE_BRUSH );
      dc.DrawRectangle( GetClientRect() );
      break;

    case kGameLogo:
      bmp = wxBitmap( _("test/titlescreen.tga") );
      break;

    default:
      dc.EndDrawing();
      return;
    }

    // calculate location
    int mid1 = this->GetClientSize().GetWidth() / 2;
    int mid2 = bmp.GetWidth() / 2;
    int x = mid1 - mid2;

    int y = 50;
    if( mState != kGameLogo )
    {
      mid1 = this->GetClientSize().GetHeight() / 2;
      mid2 = bmp.GetHeight() / 2;
      y = mid1 - mid2;
    }

    // draw!
    wxWindow* pFocus = FindFocus();
    if( pFocus == this || pFocus == mpMenu )
    {
      dc.DrawBitmap( bmp, x, y );
    }

    // sizers don't seem to work...
    y += (bmp.GetHeight() + 20);
    mid1 = this->GetClientSize().GetWidth() / 2;
    mid2 = mpMenu->GetClientSize().GetWidth() / 2;
    mpMenu->SetPosition( wxPoint(mid1-mid2,y) );
  }
  dc.EndDrawing();
}

//***********************************************************************
// OnTimer
//***********************************************************************

void TiStartFrame::OnTimer( wxTimerEvent& event )
{
  NextState();
}

//***********************************************************************
// OnEraseBackground
//***********************************************************************

void TiStartFrame::OnEraseBackground( wxEraseEvent& event )
{
  // this is here so that the scene displays in the background
  return;
}

//***********************************************************************
// Go_Click
//***********************************************************************

void TiStartFrame::Go_Click( wxCommandEvent& event )
{
  // send request up to app
  TiStartFrameEvent go( TISTARTFRAME_DEBUG_START, GetId() );
  ProcessEvent( go );
}

//***********************************************************************
// New_Click
//***********************************************************************

void TiStartFrame::New_Click( wxCommandEvent& event )
{
  event.Skip();
}

//***********************************************************************
// Load_Click
//***********************************************************************

void TiStartFrame::Load_Click( wxCommandEvent& event )
{
  event.Skip();
}

//***********************************************************************
// Options_Click
//***********************************************************************

void TiStartFrame::Options_Click( wxCommandEvent& event )
{
  event.Skip();
}

//***********************************************************************
// Credits_Click
//***********************************************************************

void TiStartFrame::Credits_Click( wxCommandEvent& event )
{
  event.Skip();
}

//***********************************************************************
// Menu_Close
//***********************************************************************

void TiStartFrame::Menu_Close( TiWindowEvent& event )
{
  // don't close menu
  event.Veto();
}

//***********************************************************************
// NewCharacter_Close
//***********************************************************************

void TiStartFrame::NewCharacter_Close( TiWindowEvent& event )
{
  mpNewCharacter->Destroy();
  mpNewCharacter = NULL;
  mpMenu->Open( true );
  mpMenu->SetFocus();

  mpSceneControl->GotoActor( -1 );
}

//***********************************************************************
// Class_Select
//***********************************************************************

void TiStartFrame::Class_Select( TiWindowEvent& event )
{
  mpSceneControl->GotoActor( event.GetIndex() );
}

//***********************************************************************
// Difficulty_Click
//***********************************************************************

void TiStartFrame::Difficulty_Click( wxCommandEvent& event )
{
  int menuId = event.GetId();

  // number of players
  int numPlayers = 1;
  switch( menuId )
  {
  case ID_START_FRAME_EASY2:
  case ID_START_FRAME_MEDIUM2:
  case ID_START_FRAME_HARD2:
  case ID_START_FRAME_EXPERT2:
    numPlayers = 2;
    break;
  case ID_START_FRAME_EASY3:
  case ID_START_FRAME_MEDIUM3:
  case ID_START_FRAME_HARD3:
  case ID_START_FRAME_EXPERT3:
    numPlayers = 3;
    break;
  case ID_START_FRAME_EASY4:
  case ID_START_FRAME_MEDIUM4:
  case ID_START_FRAME_HARD4:
  case ID_START_FRAME_EXPERT4:
    numPlayers = 4;
    break;
  }

  // difficulty
  Difficulty difficulty = kEasy;
  switch( menuId )
  {
  case ID_START_FRAME_MEDIUM1:
  case ID_START_FRAME_MEDIUM2:
  case ID_START_FRAME_MEDIUM3:
  case ID_START_FRAME_MEDIUM4:
    difficulty = kMedium;
    break;
  case ID_START_FRAME_HARD1:
  case ID_START_FRAME_HARD2:
  case ID_START_FRAME_HARD3:
  case ID_START_FRAME_HARD4:
    difficulty = kHard;
    break;
  case ID_START_FRAME_EXPERT1:
  case ID_START_FRAME_EXPERT2:
  case ID_START_FRAME_EXPERT3:
  case ID_START_FRAME_EXPERT4:
    difficulty = kExpert;
    break;
  }

  int w, h;
  wxDisplaySize( &w, &h );

  // open character selection window
  wxASSERT( mpNewCharacter == NULL );
  mpNewCharacter = new TiNewCharacterWindow( this, NULL, 0 );
  mpNewCharacter->SetSize( w, h );
  mpNewCharacter->SetFocus();
  mpNewCharacter->Open( true );
  mpMenu->Close( true );

  event.Skip();
}

//***********************************************************************
// Arena_Click
//***********************************************************************

void TiStartFrame::Arena_Click( wxCommandEvent& event )
{
  event.Skip();
}

//***********************************************************************
// Internet_Click
//***********************************************************************

void TiStartFrame::Internet_Click( wxCommandEvent& event )
{
  event.Skip();
}
