/********************************************************************

  Module: TiStartFrame

  Author: Carlo Ordonez

  Description:

    Start/Splash/Title screen

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiStartFrame_h_
#define _TiStartFrame_h_

#include "wx/wx.h"
#include "TiWindowEvent.h"

#define ID_START_FRAME              (wxID_HIGHEST + 0x0c00)
#define ID_START_FRAME_LIST           (ID_START_FRAME + 0x01)
#define ID_START_FRAME_TIMER          (ID_START_FRAME + 0x02)
#define ID_START_FRAME_MENU           (ID_START_FRAME + 0x03)
#define ID_START_FRAME_GO             (ID_START_FRAME + 0x04)
#define ID_START_FRAME_NEW            (ID_START_FRAME + 0x05)
#define ID_START_FRAME_LOAD           (ID_START_FRAME + 0x06)
#define ID_START_FRAME_OPTIONS        (ID_START_FRAME + 0x07)
#define ID_START_FRAME_CREDITS        (ID_START_FRAME + 0x08)
#define ID_START_FRAME_NORMAL_GAME    (ID_START_FRAME + 0x09)
#define ID_START_FRAME_INTERNET_GAME  (ID_START_FRAME + 0x0a)
#define ID_START_FRAME_1PLAYER        (ID_START_FRAME + 0x0b)
#define ID_START_FRAME_2PLAYER        (ID_START_FRAME + 0x0c)
#define ID_START_FRAME_3PLAYER        (ID_START_FRAME + 0x0d)
#define ID_START_FRAME_4PLAYER        (ID_START_FRAME + 0x0e)
#define ID_START_FRAME_CAMPAIGN       (ID_START_FRAME + 0x0f)
#define ID_START_FRAME_ARENA          (ID_START_FRAME + 0x10)

// menu items for each difficulty/number of players combo
#define ID_START_FRAME_EASY1          (ID_START_FRAME + 0x11)
#define ID_START_FRAME_MEDIUM1        (ID_START_FRAME + 0x12)
#define ID_START_FRAME_HARD1          (ID_START_FRAME + 0x13)
#define ID_START_FRAME_EXPERT1        (ID_START_FRAME + 0x14)
#define ID_START_FRAME_EASY2          (ID_START_FRAME + 0x15)
#define ID_START_FRAME_MEDIUM2        (ID_START_FRAME + 0x16)
#define ID_START_FRAME_HARD2          (ID_START_FRAME + 0x17)
#define ID_START_FRAME_EXPERT2        (ID_START_FRAME + 0x18)
#define ID_START_FRAME_EASY3          (ID_START_FRAME + 0x19)
#define ID_START_FRAME_MEDIUM3        (ID_START_FRAME + 0x1a)
#define ID_START_FRAME_HARD3          (ID_START_FRAME + 0x1b)
#define ID_START_FRAME_EXPERT3        (ID_START_FRAME + 0x1c)
#define ID_START_FRAME_EASY4          (ID_START_FRAME + 0x1d)
#define ID_START_FRAME_MEDIUM4        (ID_START_FRAME + 0x1e)
#define ID_START_FRAME_HARD4          (ID_START_FRAME + 0x1f)
#define ID_START_FRAME_EXPERT4        (ID_START_FRAME + 0x20)

class TitanUI;
class TiMenu;
class TiSceneController;
class TiNewCharacterWindow;

class TiStartFrame : public wxFrame
{
public:
  TiStartFrame( wxWindow* pParent, int WindowId = ID_START_FRAME, const wxString& Caption = _("Start") );
  ~TiStartFrame();

  void            OnUpdateGame();
  void            OnRenderGame();

private:

  enum State
  {
    kEsrbLogo,
    kSOELogo,
    kGameLogo,
  };
  enum Difficulty
  { 
    kEasy,
    kMedium,
    kHard,
    kExpert,
  };

  void            OnKeyDown( wxKeyEvent& event );
  void            OnJoyButtonDown( wxJoystickEvent& event );
  void            OnPaint( wxPaintEvent& event );
  void            OnTimer( wxTimerEvent& event );
  void            OnEraseBackground( wxEraseEvent& event );

  void            Menu_Close( TiWindowEvent& event );
  void            NewCharacter_Close( TiWindowEvent& event );
  void            Class_Select( TiWindowEvent& event );
  void            Go_Click( wxCommandEvent& event );
  void            New_Click( wxCommandEvent& event );
  void            Load_Click( wxCommandEvent& event );
  void            Options_Click( wxCommandEvent& event );
  void            Credits_Click( wxCommandEvent& event );
  void            Difficulty_Click( wxCommandEvent& event );
  void            Arena_Click( wxCommandEvent& event );
  void            Internet_Click( wxCommandEvent& event );

  void            NextState();
  void            LoadScene();

  TitanUI*        mpTitanUI;    // for joystick events
  TiMenu*         mpMenu;
  wxTimer         mTimer;
  State           mState;

  wxMenu*         mpMenuStart;

  TiSceneController*      mpSceneControl;
  TiNewCharacterWindow*   mpNewCharacter;

  DECLARE_CLASS( TiStartFrame )
  DECLARE_EVENT_TABLE()
};

#endif

