/********************************************************************

  Module: TiWindowEvent

  Author: Carlo Ordonez

  Description:

    Events a game window fires.

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiWindowEvent_h_
#define _TiWindowEvent_h_

#include "wx/event.h"

// event prototypes
DECLARE_EVENT_TYPE( TIWINDOW_CLOSE, -1 )
DECLARE_EVENT_TYPE( TIWINDOW_SELECT_CLASS, -1 )

// for subscribing via event tables
#define EVT_TIWINDOW_CLOSE(winId,func)            DECLARE_EVENT_TABLE_ENTRY( TIWINDOW_CLOSE, winId, wxID_ANY, (wxObjectEventFunction)(wxEventFunction)wxStaticCastEvent( TiWindowEventFunction, &func ), (wxObject*)NULL ),
#define EVT_TIWINDOW_SELECT_CLASS(winId,func)     DECLARE_EVENT_TABLE_ENTRY( TIWINDOW_SELECT_CLASS, winId, wxID_ANY, (wxObjectEventFunction)(wxEventFunction)wxStaticCastEvent( TiWindowEventFunction, &func ), (wxObject*)NULL ),

class TiWindowEvent : public wxNotifyEvent
{
public:
  // Constructor
  TiWindowEvent( int Command, int Id );

  int     GetIndex() const { return( mIndex ); }
  void    SetIndex( int Index ) { mIndex = Index; }

private:

  int     mIndex;
};

// for subscribing via wxEvtHandler::Connect()
typedef void (wxEvtHandler::*TiWindowEventFunction)(TiWindowEvent&);

#endif

