// A controller object with buttons & axes named in terms of game functions
// buttons and axis mappings are already done.

#include "TitanController.h"
#include "TitanUI.h"
#include "RawController.h"

TitanController::TitanController( RawController* pRawController ):
mpRawController(pRawController)
{
}

TitanController::~TitanController()
{
}

// returns true if the controller is connected.
bool TitanController::GetConnected() const
{
  return true;
}

// returns true if the specified button is depressed.
bool TitanController::GetButtonState( TitanButton tb ) const
{
  int buttonId = TitanUI::GetButtonIndex(tb);
  if ( buttonId == -1 )
  {
    return false;
  }
  return mpRawController->GetButton( buttonId ) != 0;
}

// returns a value in the range [-10000,+10000] that indicates whether
// the directional control is pushed completely forward (+10000),
// int backward (-10000) or somewhere in between.
int TitanController::GetForward() const
{
  int axisIndex = TitanUI::GetAxisIndex(1);

  return -1 * mpRawController->GetAxis(axisIndex);
}

// returns a value in the range [-10000,+10000] that indicates whether
// the right directional control is pushed completely to the right (+10000),
// completely to the left (-10000) or somewhere in between.
int TitanController::GetRight() const
{
  int axisIndex = TitanUI::GetAxisIndex(0);

  return mpRawController->GetAxis(axisIndex);
}

// returns a value in the range [-10000,+10000] that indicates whether
// the directional control is pushed completely forward (+10000),
// int backward (-10000) or somewhere in between.
int TitanController::GetRightStickForward() const
{
  int axisIndex = TitanUI::GetAxisIndex(3);

  return mpRawController->GetAxis(axisIndex);
}

// returns a value in the range [-10000,+10000] that indicates whether
// the right directional control is pushed completely to the right (+10000),
// completely to the left (-10000) or somewhere in between.
int TitanController::GetRightStickRight() const
{
  int axisIndex = TitanUI::GetAxisIndex(2);

  return mpRawController->GetAxis(axisIndex);
}

float TitanController::Normalize(int in) const
{
  float value = (float)in / TitanControllerI::DIRECTION_MAX;
  static const float THRESHOLD = 0.35f;
  if (value > THRESHOLD)
  {
    value = (value-THRESHOLD)/(1.0f - THRESHOLD);
  }
  else if (value < -THRESHOLD)
  {
    value = (value+THRESHOLD)/(1.0f - THRESHOLD);
  }
  else
  {
    value = 0.0f;
  }
  return value;
}

