/////////////////////////////////////////////////////////////////////////////
// Name:        TitanFrame.h
// Purpose:     
// Author:      Vince Harron
// Modified by: 
// Created:     06/07/05 12:57:53
// RCS-ID:      
// Copyright:   2005 Sony Online Entertainment
// Licence:     
/////////////////////////////////////////////////////////////////////////////

#ifndef _TITANFRAME_H_
#define _TITANFRAME_H_

#if defined(__GNUG__) && !defined(__APPLE__)
#pragma interface "TitanFrame.h"
#endif

/*!
 * Includes
 */

////@begin includes
#include "wx/frame.h"
////@end includes
#include "TiWindowEvent.h"

/*!
 * Forward declarations
 */

////@begin forward declarations
class wxBoxSizer;
class wxFlexGridSizer;
////@end forward declarations
class TitanI;
class TitanUI;
class TitanController;
class TitanHUD;
class TiCharacterWindow;
class TiActivateWindow;
class TiMenu;

/*!
 * Control identifiers
 */

////@begin control identifiers
#define ID_FRAME 10000
#define SYMBOL_TITANFRAME_STYLE wxNO_BORDER
#define SYMBOL_TITANFRAME_TITLE _("TitanFrame")
#define SYMBOL_TITANFRAME_IDNAME ID_FRAME
#define SYMBOL_TITANFRAME_SIZE wxSize(400, 300)
#define SYMBOL_TITANFRAME_POSITION wxDefaultPosition
#define ID_PANEL 10045
#define ID_FPS 10027
#define ID_FPS_AVG 10001
#define ID_STATICTEXT 10028
#define ID_STATICTEXT2 10030
#define ID_STATICTEXT3 10031
#define ID_STATICTEXT4 10032
#define ID_STATICTEXT5 10033
#define ID_STATICTEXT1 10029
#define ID_STATICTEXT7 10040
#define ID_STATICTEXT6 10039
#define ID_STATICTEXT8 10041
#define ID_STATICTEXT9 10042
#define ID_MENU 10003
#define ID_MENU_NTSC 10005
#define ID_MENU_480P 10006
#define ID_MENU_720P 10007
#define ID_MENU_1080P 10008
#define ID_MENU_960x624 10009
#define ID_MENU_1920x1248 10004
#define ID_MENU_DESIGN 10011
#define ID_MENUITEM_INVISIBLE 10012
#define ID_MENUITEM_GOD 10013
#define ID_MENUITEM_LOG 10014
#define ID_MENUITEM_LABEL 10016
#define ID_MENUITEM_RESTART 10015
#define ID_MENU_RENDER 10017
#define ID_MENUITEM_BLOOM 10018
#define ID_MENUITEM_SKY 10043
#define ID_MENUITEM_MULTI_PASS 10002
#define ID_MENUITEM_RENDER_STATS 10010
#define ID_MENUITEM_RENDER_DRAWMODE 10034
#define ID_MENUITEM_RENDER_DRAWMODE_NORMAL 10022
#define ID_MENUITEM_RENDER_DRAWMODE_WIRE 10035
#define ID_MENUITEM_RENDER_DRAWMODE_SOLIDFILL 10036
#define ID_MENU_PROGRAMMING 10019
#define ID_MENUITEM_BUILDINFO 10038
#define ID_MENUITEM_WXCARLO 10020
#define ID_MENUITEM_WXVINCE 10037
#define ID_MENU_SOUND 10021
#define ID_MENUITEM_MONO 10023
#define ID_MENUITEM_STEREO 10024
#define ID_MENUITEM_SURROUND51 10025
#define ID_MENUITEM_SURROUND71 10026
////@end control identifiers

/*!
 * Compatibility
 */

#ifndef wxCLOSE_BOX
#define wxCLOSE_BOX 0x1000
#endif
#ifndef wxFIXED_MINSIZE
#define wxFIXED_MINSIZE 0
#endif

/*!
 * TitanFrame class declaration
 */

class TitanFrame: public wxFrame
{    
    DECLARE_CLASS( TitanFrame )
    DECLARE_EVENT_TABLE()

public:
    /// Constructors
    TitanFrame( );
    TitanFrame( const char *netRecordFilename, 
                const char *netPlaybackFilename, 
                bool bloomEnabled, 
                bool multiPass, 
                bool net, 
                const char *levelname, 
                bool showUI, 
                bool pawnDebug,
                bool checkArt,
                int numPlayers,
                wxWindow* parent, 
                wxWindowID id = SYMBOL_TITANFRAME_IDNAME, 
                const wxString& caption = SYMBOL_TITANFRAME_TITLE, 
                const wxPoint& pos = SYMBOL_TITANFRAME_POSITION, 
                const wxSize& size = SYMBOL_TITANFRAME_SIZE, 
                long style = SYMBOL_TITANFRAME_STYLE );

    virtual ~TitanFrame();

    bool Create( const char *netRecordFilename, 
                 const char *netPlaybackFilename, 
                 bool bloomEnabled, 
                 bool multiPass, 
                 bool net, 
                 const char *levelname, 
                 bool showUI, 
                 bool pawnDebug,
                 bool checkArt,
                 int numPlayers,
                 wxWindow* parent, 
                 wxWindowID id = SYMBOL_TITANFRAME_IDNAME, 
                 const wxString& caption = SYMBOL_TITANFRAME_TITLE, 
                 const wxPoint& pos = SYMBOL_TITANFRAME_POSITION, 
                 const wxSize& size = SYMBOL_TITANFRAME_SIZE, 
                 long style = SYMBOL_TITANFRAME_STYLE);

    /// Creates the controls and sizers
    void CreateControls();

////@begin TitanFrame event handler declarations

    /// wxEVT_ERASE_BACKGROUND event handler for ID_FRAME
    void OnEraseBackground( wxEraseEvent& event );

    /// wxEVT_KEY_DOWN event handler for ID_FRAME
    void OnKeyDown( wxKeyEvent& event );

    /// wxEVT_KEY_UP event handler for ID_FRAME
    void OnKeyUp( wxKeyEvent& event );

    /// wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENU_NTSC
    void OnMenuNtscClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENU_480P
    void OnMenu480pClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENU_720P
    void OnMenu720pClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENU_1080P
    void OnMenu1080pClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENU_960x624
    void OnMenu960x624Click( wxCommandEvent& event );

    /// wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENU_1920x1248
    void OnMenu1920x1248Click( wxCommandEvent& event );

    /// wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENUITEM_INVISIBLE
    void OnMenuitemInvisibleClick( wxCommandEvent& event );

    /// wxEVT_UPDATE_UI event handler for ID_MENUITEM_INVISIBLE
    void OnMenuitemInvisibleUpdate( wxUpdateUIEvent& event );

    /// wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENUITEM_GOD
    void OnMenuitemGodClick( wxCommandEvent& event );

    /// wxEVT_UPDATE_UI event handler for ID_MENUITEM_GOD
    void OnMenuitemGodUpdate( wxUpdateUIEvent& event );

    /// wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENUITEM_LOG
    void OnMenuitemLogClick( wxCommandEvent& event );

    /// wxEVT_UPDATE_UI event handler for ID_MENUITEM_LOG
    void OnMenuitemLogUpdate( wxUpdateUIEvent& event );

    /// wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENUITEM_LABEL
    void OnMenuitemLabelClick( wxCommandEvent& event );

    /// wxEVT_UPDATE_UI event handler for ID_MENUITEM_LABEL
    void OnMenuitemLabelUpdate( wxUpdateUIEvent& event );

    /// wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENUITEM_RESTART
    void OnMenuitemRestartClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENUITEM_BLOOM
    void OnMenuitemBloomClick( wxCommandEvent& event );

    /// wxEVT_UPDATE_UI event handler for ID_MENUITEM_BLOOM
    void OnMenuitemBloomUpdate( wxUpdateUIEvent& event );

    /// wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENUITEM_SKY
    void OnMenuitemSkyClick( wxCommandEvent& event );

    /// wxEVT_UPDATE_UI event handler for ID_MENUITEM_SKY
    void OnMenuitemSkyUpdate( wxUpdateUIEvent& event );

    /// wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENUITEM_MULTI_PASS
    void OnMenuitemMultiPassClick( wxCommandEvent& event );

    /// wxEVT_UPDATE_UI event handler for ID_MENUITEM_MULTI_PASS
    void OnMenuitemMultiPassUpdate( wxUpdateUIEvent& event );

    /// wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENUITEM_RENDER_STATS
    void OnMenuitemRenderStatsClick( wxCommandEvent& event );

    /// wxEVT_UPDATE_UI event handler for ID_MENUITEM_RENDER_STATS
    void OnMenuitemRenderStatsUpdate( wxUpdateUIEvent& event );

    /// wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENUITEM_RENDER_DRAWMODE_NORMAL
    void OnMenuitemRenderDrawmodeNormalClick( wxCommandEvent& event );

    /// wxEVT_UPDATE_UI event handler for ID_MENUITEM_RENDER_DRAWMODE_NORMAL
    void OnMenuitemRenderDrawmodeNormalUpdate( wxUpdateUIEvent& event );

    /// wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENUITEM_RENDER_DRAWMODE_WIRE
    void OnMenuitemRenderDrawmodeWireClick( wxCommandEvent& event );

    /// wxEVT_UPDATE_UI event handler for ID_MENUITEM_RENDER_DRAWMODE_WIRE
    void OnMenuitemRenderDrawmodeWireUpdate( wxUpdateUIEvent& event );

    /// wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENUITEM_RENDER_DRAWMODE_SOLIDFILL
    void OnMenuitemRenderDrawmodeSolidfillClick( wxCommandEvent& event );

    /// wxEVT_UPDATE_UI event handler for ID_MENUITEM_RENDER_DRAWMODE_SOLIDFILL
    void OnMenuitemRenderDrawmodeSolidfillUpdate( wxUpdateUIEvent& event );

    /// wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENUITEM_BUILDINFO
    void OnMenuitemBuildinfoClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENUITEM_WXCARLO
    void OnMenuitemWxcarloClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENUITEM_WXVINCE
    void OnMenuitemWxvinceClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENUITEM_MONO
    void OnMenuitemMonoClick( wxCommandEvent& event );

    /// wxEVT_UPDATE_UI event handler for ID_MENUITEM_MONO
    void OnMenuitemMonoUpdate( wxUpdateUIEvent& event );

    /// wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENUITEM_STEREO
    void OnMenuitemStereoClick( wxCommandEvent& event );

    /// wxEVT_UPDATE_UI event handler for ID_MENUITEM_STEREO
    void OnMenuitemStereoUpdate( wxUpdateUIEvent& event );

    /// wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENUITEM_SURROUND51
    void OnMenuitemSurround51Click( wxCommandEvent& event );

    /// wxEVT_UPDATE_UI event handler for ID_MENUITEM_SURROUND51
    void OnMenuitemSurround51Update( wxUpdateUIEvent& event );

    /// wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENUITEM_SURROUND71
    void OnMenuitemSurround71Click( wxCommandEvent& event );

    /// wxEVT_UPDATE_UI event handler for ID_MENUITEM_SURROUND71
    void OnMenuitemSurround71Update( wxUpdateUIEvent& event );

////@end TitanFrame event handler declarations

    /// wxEVT_JOY_BUTTON_DOWN event handler
    void OnJoyButtonDown( wxJoystickEvent& event );

    /// wxEVT_JOY_BUTTON_UP event handler
    void OnJoyButtonUp( wxJoystickEvent& event );

    /// wxEVT_TIMER event handler
    void OnTimer( wxTimerEvent& event );

    /// wxEVT_DISPLAY_CHANGED event handler
    void OnDisplayChanged( wxDisplayChangedEvent& event );

    /// TIWINDOW_CLOSE event handler
    void OnCharacterWindowClose( TiWindowEvent& event );

////@begin TitanFrame member function declarations

    /// Retrieves bitmap resources
    wxBitmap GetBitmapResource( const wxString& name );

    /// Retrieves icon resources
    wxIcon GetIconResource( const wxString& name );
////@end TitanFrame member function declarations

    /// Should we show tooltips?
    static bool ShowToolTips();

    // Handles the update game event
    void OnUpdateGame();

    // Handles the render game event
    void OnRenderGame();

    // render the HUD
    void OnRenderHUD();

    bool GetNet() const;
    void SetNet( bool value );

    bool GetShowUI() const { return( mbShowUI ); }
    void SetShowUI( bool Show ) { mbShowUI = Show; }

    void StartPerformanceProfile();

    void OpenCharacterWindow();
    void CloseCharacterWindow();
 
    void IncreaseTimeScale();
    void DecreaseTimeScale();
////@begin TitanFrame member variables
    wxBoxSizer* mpMainSizer;
    wxPanel* mpStatsPanel;
    wxFlexGridSizer* mpStatsGrid;
    wxStaticText* mpFPS;
    wxStaticText* mpFPSAvg;
    wxStaticText* mpBatches;
    wxStaticText* mpBatchesAvg;
    wxStaticText* mpVertexes;
    wxStaticText* mpVertexesAvg;
    wxStaticText* mpTriangles;
    wxStaticText* mpTrianglesAvg;
    wxStaticText* mpDegenerateTriangles;
    wxStaticText* mpDegenerateTrianglesAvg;
    wxStaticText* mpFill;
    wxStaticText* mpFillAvg;
////@end TitanFrame member variables

    TitanI*          mpTitan;
    TitanUI*         mpTitanUI;

    wxTimer          mTimer;
    wxLongLong       mTime;
    bool             mbShowStats;
    bool             mbShowUI;

    wxMenu*          mpStartMenu;
    TiMenu*          mpTitanMenu;
    bool             mNet;
    int              mFramesRendered;          // number of frames rendered

    bool             mWxTest;

    TitanHUD*           mpHUD;
    TiCharacterWindow*  mpCharacterWin;
    TiActivateWindow*   mpActivateWin;

    bool             mbShowPawnOutput;
};

#endif
    // _TITANFRAME_H_
