/********************************************************************

  Module: TitanHUD

  Author: Carlo Ordonez

  Description:

    Displays name, power bars

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#include "TitanHUD.h"
#include "SyMath.h"

IMPLEMENT_CLASS( TitanHUD, TiWindow )

BEGIN_EVENT_TABLE( TitanHUD, TiWindow )
EVT_PAINT( TitanHUD::OnPaint )
END_EVENT_TABLE()

TitanHUD::TitanHUD( wxWindow* pParent, TitanI* pTitan, int PlayerId, const wxString& Name, int WindowId )
: TiWindow( pParent, pTitan, PlayerId, Name, WindowId )
{
  mHealth     = 10;
  mHealthMax  = 10;
  mBlock      = 10;
  mBlockMax   = 10;
  mXP         = 10;
  mXPMax      = 10;

  this->SetSize( 0, 0 );
}

TitanHUD::~TitanHUD()
{
}

void TitanHUD::SetPlayerName( const wxString& Name )
{
  mPlayerName = Name;
}

void TitanHUD::SetHealth( int Health )
{
  int health = SY_CLAMP( Health, 0, mHealthMax );
  mHealth = health;
}

void TitanHUD::SetHealthMax( int HealthMax )
{
  mHealthMax = SY_MAX( 1, HealthMax );
}

void TitanHUD::SetBlock( int Block )
{
  int block = SY_CLAMP( Block, 0, mBlockMax );
  mBlock = block;
}

void TitanHUD::SetBlockMax( int BlockMax )
{
  mBlockMax = SY_MAX( 1, BlockMax );
}

void TitanHUD::SetXP( int Experience )
{
  int xp = SY_CLAMP( Experience, 0, mXPMax );
  mXP = xp;
}

void TitanHUD::SetXPMax( int ExperienceMax )
{
  mXPMax = SY_MAX( 1, ExperienceMax );
}

void TitanHUD::OnPaint( wxPaintEvent& event )
{
  wxPaintDC dc( this );
  PrepareDC( dc );
  dc.BeginDrawing();
  {
    wxBitmap hudLeft( _("test/hudLeft.tga") );
    wxBitmap hudTile( _("test/hudTile.tga") );
    wxBitmap hudRight( _("test/hudRight.tga") );
    wxBitmap hudFace( _("test/hudFace.tga") );
    wxBitmap health( _("test/health.tga") );
    wxBitmap xp( _("test/experience.tga") );
    wxBitmap mana( _("test/mana.tga") );

    wxPoint pt;

    // left cap
    pt.x = 0;
    pt.y = 0;
    dc.DrawBitmap( hudLeft, pt );

    // opaque bar background
    pt.x = hudLeft.GetWidth();
    pt.y += 2;
    wxRect rect( pt, wxSize( xp.GetWidth(), hudTile.GetHeight()-5 ) );
    dc.SetPen( *wxBLACK_PEN );
    dc.SetBrush( *wxBLACK_BRUSH );
    dc.DrawRectangle( rect );

    // health bar
    float32 f = (float32)mHealth / (float32)mHealthMax;
    int w = int32((float32)health.GetWidth() * f);

    pt.x = hudLeft.GetWidth() - 1;
    pt.y = 4;
    dc.DrawBitmap( health, pt.x, pt.y, w, health.GetHeight(), 0, 0, w, health.GetHeight() );

    // experience bar
    f = (float32)mXP / (float32)mXPMax;
    w = int32((float32)xp.GetWidth() * f);

    pt.y = 14;
    dc.DrawBitmap( xp, pt.x, pt.y, w, xp.GetHeight(), 0, 0, w, xp.GetHeight() );

    // block bar
    f = (float32)mBlock / (float32)mBlockMax;
    w = int32((float32)mana.GetWidth() * f);

    pt.y = 24;
    dc.DrawBitmap( mana, pt.x, pt.y, w, mana.GetHeight(), 0, 0, w, mana.GetHeight() );

    // bar frames
    pt.y = 0;
    rect = wxRect( pt, wxSize( xp.GetWidth()-7, hudTile.GetHeight() ) );
    TileBitmap( rect, dc, hudTile );//dc.DrawBitmap( hudTile, pt );

    // right cap
    pt.x += rect.GetWidth();
    dc.DrawBitmap( hudRight, pt );

    // portrait
    pt.x += hudRight.GetWidth();
    pt.y -= 13;
    dc.DrawBitmap( hudFace, pt );
  }
  dc.EndDrawing();
}
