/********************************************************************

  Module: TitanHUD

  Author: Carlo Ordonez

  Description:

    Displays name, power bars

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TitanHUD_h_
#define _TitanHUD_h_

#include "TiWindow.h"

#define ID_TITANFRAME_HUD     (wxID_HIGHEST + 0x0100)

class TitanHUD : public TiWindow
{
public:

  TitanHUD( wxWindow* pParent, TitanI* pTitan, int PlayerId, const wxString& Name = _("HUD"), int WindowId = ID_TITANFRAME_HUD );
  ~TitanHUD();

  void    SetPlayerName( const wxString& Name );

  void    SetHealth( int Health );
  void    SetHealthMax( int HealthMax );

  void    SetBlock( int Block );
  void    SetBlockMax( int BlockMax );

  void    SetXP( int Experience );
  void    SetXPMax( int ExperienceMax );

protected:

  void    OnPaint( wxPaintEvent& event );

private:

  wxString        mPlayerName;
  int             mHealth;
  int             mHealthMax;
  int             mBlock;
  int             mBlockMax;
  int             mXP;
  int             mXPMax;

  DECLARE_CLASS( TitanHUD );
  DECLARE_EVENT_TABLE();
};

#endif
