/********************************************************************

  Module: TitanOptions

  Author: Carlo Ordonez

  Description:

    Gametime options for the player

  Copyright 2006 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#include "TitanOptions.h"
#include "SySoundDevice.h"
#include "SyScene.h"

TitanOptions::TitanOptions(TitanUII* pTitanUI)
{
  mpTitanUI       = pTitanUI;
  mBrightness     = 1.f;
  mAmbientVolume  = 1.f;
  mFxVolume       = 1.f;
  mCameraSwivel   = false;
  mReverseCamera  = false;
  mVibrate        = true;
  mStereo         = true;
  mBlood          = true;
  mSubtitles      = true;
  mDamageText     = true;
  mChatText       = true;
  mPlayerMarkers  = true;
}

TitanOptions::~TitanOptions()
{
}

float32 TitanOptions::GetBrightness() const
{
  return( mBrightness );
}

void TitanOptions::SetBrightness( float32 Brightness )
{
  mBrightness = SY_CLAMP( Brightness, 0.f, 1.f );
}

float32 TitanOptions::GetAmbientVolume() const
{
  return( mAmbientVolume );
}

void TitanOptions::SetAmbientVolume( float32 Volume )
{
  mAmbientVolume = SY_CLAMP( Volume, 0.f, 1.f );
  mpTitanUI->GetScene()->GetSoundDev()->SetSoundClassVolume(SySoundDevice::kSoundClassMusic, mAmbientVolume);
}

float32 TitanOptions::GetSoundFxVolume() const
{
  return( mFxVolume );
}

void TitanOptions::SetSoundFxVolume( float32 Volume )
{
  mFxVolume = SY_CLAMP( Volume, 0.f, 1.f );
  mpTitanUI->GetScene()->GetSoundDev()->SetSoundClassVolume(SySoundDevice::kSoundClassFx, mFxVolume);
}

bool TitanOptions::GetCameraSwivel() const
{
  return( mCameraSwivel );
}

void TitanOptions::SetCameraSwivel( bool On )
{
  mCameraSwivel = On;
}

bool TitanOptions::GetReverseCameraInputs() const
{
  return( mReverseCamera );
}

void TitanOptions::SetReverseCameraInputs( bool On )
{
  mReverseCamera = On;
  mpTitanUI->GetTitanI()->ReverseCamera(mReverseCamera);
}

bool TitanOptions::GetVibration() const
{
  return( mVibrate );
}

void TitanOptions::SetVibration( bool On )
{
  mVibrate = On;
}

bool TitanOptions::GetStereo() const
{
  return( mStereo );
}

void TitanOptions::SetStereo( bool On )
{
  mStereo = On;
}

bool TitanOptions::GetBlood() const
{
  return( mBlood );
}

void TitanOptions::SetBlood( bool On )
{
  mBlood = On;
}

bool TitanOptions::GetSubtitles() const
{
  return( mSubtitles );
}

void TitanOptions::SetSubtitles( bool On )
{
  mSubtitles = On;
}

bool TitanOptions::GetDamageText() const
{
  return( mDamageText );
}

void TitanOptions::SetDamageText( bool On )
{
  mDamageText = On;
  mpTitanUI->GetTitanI()->SetShowDamageFlash(mDamageText);
}

bool TitanOptions::GetChatText() const
{
  return( mChatText );
}

void TitanOptions::SetChatText( bool On )
{
  mChatText = On;
}

bool TitanOptions::GetPlayerMarkers() const
{
  return( mPlayerMarkers );
}

void TitanOptions::SetPlayerMarkers( bool On )
{
  mPlayerMarkers = On;
}

