/********************************************************************

  Module: TitanOptions

  Author: Carlo Ordonez

  Description:

    Gametime options for the player

  Copyright 2006 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TitanOptions_h_
#define _TitanOptions_h_

#include "TitanI.h"

class TitanOptions : public TitanOptionsI
{
public:
  TitanOptions(TitanUII* pTitanUI);
  virtual ~TitanOptions();

  // tunable settings
  virtual float32   GetBrightness() const;
  virtual void      SetBrightness( float32 Brightness );

  virtual float32   GetAmbientVolume() const;
  virtual void      SetAmbientVolume( float32 Volume );

  virtual float32   GetSoundFxVolume() const;
  virtual void      SetSoundFxVolume( float32 Volume );

  // on/off settings
  virtual bool      GetCameraSwivel() const;
  virtual void      SetCameraSwivel( bool On );

  virtual bool      GetReverseCameraInputs() const;
  virtual void      SetReverseCameraInputs( bool On );

  virtual bool      GetVibration() const;
  virtual void      SetVibration( bool On );

  virtual bool      GetStereo() const;
  virtual void      SetStereo( bool On );

  virtual bool      GetBlood() const;
  virtual void      SetBlood( bool On );

  virtual bool      GetSubtitles() const;
  virtual void      SetSubtitles( bool On );

  virtual bool      GetDamageText() const;
  virtual void      SetDamageText( bool On );

  virtual bool      GetChatText() const;
  virtual void      SetChatText( bool On );

  virtual bool      GetPlayerMarkers() const;
  virtual void      SetPlayerMarkers( bool On );

private:

  TitanUII*         mpTitanUI;

  float32           mBrightness;
  float32           mAmbientVolume;
  float32           mFxVolume;
  bool              mCameraSwivel;
  bool              mReverseCamera;
  bool              mVibrate;
  bool              mStereo;
  bool              mBlood;
  bool              mSubtitles;
  bool              mDamageText;
  bool              mChatText;
  bool              mPlayerMarkers;
};

#endif

