
#include "TitanUI.h"
#include "SyTime.h"
#include "SyAssert.h"
#include "SyESFParse.h"
#include "t4.h"
#include "SyPlatformMisc.h"
#include "SyCommandLineParser.h"
#include "SyParameterValidator.h"
#include "SyDebug.h"
#include <memory>

#ifdef SNTUNER
#include "libsntuner.h"
#endif // SNTUNER

int entry( int argc, char* argv[] )
{
  SyParameterValidator parameterValidator;

  std::auto_ptr<TitanUI> pTitanUI( new TitanUI() );

  pTitanUI->InitParameterValidator( &parameterValidator );

  if ( parameterValidator.SetArgs( argc, argv ) < 0 )
  {
    SyOutputString( "%s\n", parameterValidator.GetError() );
    return -1;
  }

  if ( pTitanUI->Init() < 0 )
  {
    return -1;
  }

  pTitanUI->Main();

  return 0;
}

#ifdef WIN32

    #include <windows.h>

    int
    WINAPI
    WinMain(
            HINSTANCE hInstance,
            HINSTANCE hPrevInstance,
            char* pCmdLine,
            int nCmdShow
            )
    {
    SyPlatform::ProcessInitialize();

    SyCommandLineParser commandLineParser;
    commandLineParser.ParseString( pCmdLine );

    int result = entry( commandLineParser.GetArgCount(), commandLineParser.GetArgVector() );

    SyPlatform::ProcessTerminate();

    return result;
    }

#else   // WIN32


    #include <stdio.h>
    #include "SyPlatformThread.h"

    #include <sys/process.h>
    #include <sys/raw_spu.h>
    #include <sys/spu_initialize.h>
    #include <sys/timer.h>
    #include <sys/ppu_thread.h>


    int threadmain( int argc, const char **argv );

    class BigStackThread : public SyPlatform::ThreadObject
    {
    public:
        BigStackThread(int argc, const char **argv) : SyPlatform::ThreadObject(1 * 1024 * 1024)
        {
            m_argc = argc;
            m_argv = argv;
        }

    protected:
        virtual void Run()
        {
            threadmain(m_argc, m_argv);
        }

        int m_argc;
        const char **m_argv;
    };


    int threadmain( int argc, const char **argv )
    {
        return(entry( argc, const_cast<char **>(argv) ));
    }

    int main( int argc, const char **argv)
    {
        SyPlatform::ProcessInitialize();

#ifdef SNTUNER
        snTunerInit();
#endif // SNTUNER

        BigStackThread *st = new BigStackThread(argc, argv);
        st->Start();
        for (;;)
        {
            SyPlatform::Sleep(10000);
        }
        delete st;

        SyPlatform::ProcessTerminate();
        return(0);
    }

    extern "C"
    {

        // I guess this isn't implemented on the PS3?
        int time()
        {
            return 0;
        }

    } // extern "C"

#endif  // WIN32
