/* SCE CONFIDENTIAL
 * PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
 * Copyright (C) 2006 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */

#ifndef __CELL_DAISY_ERROR_H__
#define __CELL_DAISY_ERROR_H__

#include <cell/error.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*
  CELL_ERROR_FACILITY_SPU				 0x041
  libdaisy		: 0x8041_0501 - 0x8041_05ff
*/

#define CELL_DAISY_MAKE_ERROR(status) \
	CELL_ERROR_MAKE_ERROR(CELL_ERROR_FACILITY_SPU, status)

/*  The function to end push/pop is called,
 *  although no pending push/pop exist.
 */
/* ERR: CELL_DAISY_MAKE_ERROR(0x0501) */
#define CELL_DAISY_ERROR_NO_BEGIN CELL_ERROR_CAST(0x80410501)

/* invalid port attach to glue */
/* ERR: CELL_DAISY_MAKE_ERROR(0x0502) */
#define CELL_DAISY_ERROR_INVALID_PORT_ATTACH CELL_ERROR_CAST(0x80410502)

/* called functionality is not implemented */
/* ERR: CELL_DAISY_MAKE_ERROR(0x0503) */
#define CELL_DAISY_ERROR_NOT_IMPLEMENTED CELL_ERROR_CAST(0x80410503)

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __CELL_DAISY_ERROR_H__ */

/*
 * Local Variables:
 * mode:C++
 * tab-width:4
 * End:
 * vim:ts=4:sw=4:
 */
