/* SCE CONFIDENTIAL
PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
 * Copyright (C) 2006 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */

#ifndef __CELL_SPURS_JOB_GUARD_H__
#define __CELL_SPURS_JOB_GUARD_H__


#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>


// 128 bytes
typedef struct CellSpursJobGuard
{
	/// Job Guard is passed when count reaches zero.
	uint32_t count;

	uint32_t originalCount;
	
	uint64_t eaJobChain;

	uint8_t un1[3] __attribute__((__packed__));
	uint8_t readyCount __attribute__((__packed__));
	uint32_t un2[3] __attribute__((__packed__));

	uint8_t un3[3] __attribute__((__packed__));
	uint8_t autoReset __attribute__((__packed__));
	uint32_t un4[3] __attribute__((__packed__));
	
	char unused[128 - 16 - 16 - 16] __attribute__((__packed__));
} CellSpursJobGuard __attribute__((__aligned__(128)));


#ifdef __cplusplus
}
#endif


#endif /* __CELL_SPURS_JOB_GUARD_H__ */

/*
 * Local Variables:
 * mode: C
 * c-file-style: "stroustrup"
 * tab-width: 4
 * End:
 * vim:sw=4:sts=4:ts=4
 */
