/* SCE CONFIDENTIAL
PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
 * Copyright (C) 2006 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */

#ifndef __CELL_SPURS_TASK_TYPES_H__
#define __CELL_SPURS_TASK_TYPES_H__ 1

/*
 * SPURS taskset
 */
#define CELL_SPURS_TASKSET_ALIGN	128
#define CELL_SPURS_TASKSET_SIZE		(128 * 49)
#ifndef __ASSEMBLER__
typedef struct CellSpursTaskset {
	unsigned char skip[CELL_SPURS_TASKSET_SIZE];
} CellSpursTaskset __attribute__((aligned(CELL_SPURS_TASKSET_ALIGN)));
#endif

/*
 * SPURS task
 */
#define CELL_SPURS_MAX_TASK			128
#define CELL_SPURS_TASK_TOP			0x3000
#define CELL_SPURS_TASK_BOTTOM		0x40000	/* LS_BOTTOM */
#define CELL_SPURS_CONTEXT_SIZE2BITS(size)	((size)>>11)
#define CELL_SPURS_TASK_TOP_BIT		CELL_SPURS_CONTEXT_SIZE2BITS(CELL_SPURS_TASK_TOP)
#define CELL_SPURS_TASK_TOP_MASK	(0xffffffffu>>CELL_SPURS_TASK_TOP_BIT)

#define CELL_SPURS_TASK_CONTEXT_ALIGN	128

#define CELL_SPURS_TASK_EXECUTION_CONTEXT_SIZE		1024
#define CELL_SPURS_TASK_MEMORY_CONTEXT_SIZE(size)	((size + 2047) & ~2047)
#define CELL_SPURS_TASK_CONTEXT_SIZE(size)\
		(CELL_SPURS_TASK_EXECUTION_CONTEXT_SIZE +\
		 CELL_SPURS_TASK_MEMORY_CONTEXT_SIZE(size))
#define CELL_SPURS_TASK_CONTEXT_SIZE_ALL\
		(CELL_SPURS_TASK_CONTEXT_SIZE(CELL_SPURS_TASK_BOTTOM-CELL_SPURS_TASK_TOP))

#ifndef __ASSEMBLER__
typedef unsigned CellSpursTaskId;
#endif

#endif /* __CELL_SPURS_TASK_TYPES_H__ */

/*
 * Local Variables:
 * mode: C
 * c-file-style: "stroustrup"
 * tab-width: 4
 * End:
 * vim:sw=4:sts=4:ts=4
 */
