/* SCE CONFIDENTIAL
PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
 * Copyright (C) 2006 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */

#ifndef __CELL_SPURS_TRACE_TYPES_H__
#define __CELL_SPURS_TRACE_TYPES_H__ 1

#include <stdint.h>

typedef struct CellSpursTraceHeader {
	uint8_t tag;						/* the type of information */
	uint8_t length;						/* fixed with 2 */
	uint8_t spu;						/* SPU number */
	uint8_t workload;					/* workload id */
	uint32_t time;						/* compliment of decrementer count */
} CellSpursTraceHeader;

/* CellSpursTracePacketHeader.tag */
#define CELL_SPURS_TRACE_TAG_KERNEL		0x20
#define CELL_SPURS_TRACE_TAG_SERVICE	0x21
#define CELL_SPURS_TRACE_TAG_TASK		0x22
#define CELL_SPURS_TRACE_TAG_JOB		0x23
#define CELL_SPURS_TRACE_TAG_CONTROL	0xf0

typedef struct CellSpursTraceControlData {
	uint32_t incident;
	uint32_t idSpuThread;
} CellSpursTraceControlData;

/* CellSpursTracePacketControlData.incident */
#define CELL_SPURS_TRACE_CONTROL_START	0x01
#define CELL_SPURS_TRACE_CONTROL_STOP	0x02

typedef struct CellSpursTraceServiceData {
	uint32_t incident;
	uint32_t __reserved__;
} CellSpursTraceServiceData;

/* CellSpursTracePacketServiceData.incident */
#define CELL_SPURS_TRACE_SERVICE_INIT	0x01
#define CELL_SPURS_TRACE_SERVICE_WAIT	0x02
#define CELL_SPURS_TRACE_SERVICE_EXIT	0x03

typedef struct CellSpursTraceTaskData {
	uint32_t incident;
	uint32_t task;
} CellSpursTraceTaskData;

typedef struct CellSpursTraceJobData {
	uint64_t jobDescriptor;
} CellSpursTraceJobData;

/* CellSpursTraceTaskData.incident */
#define CELL_SPURS_TRACE_TASK_DISPATCH	0x01
#define CELL_SPURS_TRACE_TASK_YIELD		0x03
#define CELL_SPURS_TRACE_TASK_WAIT		0x04
#define CELL_SPURS_TRACE_TASK_EXIT		0x05

typedef struct CellSpursTracePacket {
	CellSpursTraceHeader header;
	union {
		CellSpursTraceControlData control;
		CellSpursTraceServiceData service;
		CellSpursTraceTaskData task;
		CellSpursTraceJobData job;
		uint64_t rawData;
	} data;
} CellSpursTracePacket __attribute__((aligned(16)));

#define	CELL_SPURS_TRACE_PACKET_SIZE	8
#define	CELL_SPURS_TRACE_BUFFER_ALIGN	16

#endif /* __CELL_SPURS_TRACE_TYPES_H__ */

/*
 * Local Variables:
 * mode: C
 * c-file-style: "stroustrup"
 * tab-width: 4
 * End:
 * vim:sw=4:sts=4:ts=4
 */
