/* SCE CONFIDENTIAL
 * PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
 *                Copyright (C) 2006 Sony Computer Entertainment Inc.
 *                                               All Rights Reserved.
 */

#ifndef _cg_sce_h_
#define _cg_sce_h_

#include <PSGL/export.h>
#include <Cg/NV/cg.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Effects */
PSGLFX_EXPORT CGbool cgSetEffectName(CGeffect effect, const char *name);
PSGLFX_EXPORT const char *cgGetEffectName(CGeffect effect);
PSGLFX_EXPORT CGeffect cgGetNamedEffect(CGcontext, const char *name);
PSGLFX_EXPORT CGparameter cgCreateEffectParameter(CGeffect, const char *name, CGtype);
PSGLFX_EXPORT CGannotation cgCreateEffectAnnotation(CGeffect, const char *name, CGtype type);
PSGLFX_EXPORT CGannotation cgCreateArrayEffectAnnotation(CGeffect, const char *name, CGtype type, int nelems);

/* Techniques */
PSGLFX_EXPORT CGtechnique cgCreateTechnique(CGeffect handle, const char *name);
PSGLFX_EXPORT CGannotation cgCreateTechniqueAnnotation(CGtechnique handle, const char *name, CGtype type);
PSGLFX_EXPORT CGannotation cgCreateArrayTechniqueAnnotation(CGtechnique handle, const char *name, CGtype type, int nelems);

/* Passes */
PSGLFX_EXPORT CGpass cgCreatePass(CGtechnique handle, const char *name);
PSGLFX_EXPORT CGannotation cgCreatePassAnnotation(CGpass handle, const char *name, CGtype type);
PSGLFX_EXPORT CGannotation cgCreateArrayPassAnnotation(CGpass handle, const char *name, CGtype type, int nelems);

/* State Assignments */
PSGLFX_EXPORT CGstateassignment cgCreateStateAssignment(CGpass passHandle, CGstate stateHandle);
PSGLFX_EXPORT void cgSetStateAssignmentIndex(CGstateassignment handle, int index);
PSGLFX_EXPORT CGstateassignment cgCreateSamplerStateAssignment(CGparameter samplerHandle, CGstate stateHandle);
PSGLFX_EXPORT CGbool cgSetFloatStateAssignment(CGstateassignment handle, float f);
PSGLFX_EXPORT CGbool cgSetIntStateAssignment(CGstateassignment handle, int i);
PSGLFX_EXPORT CGbool cgSetBoolStateAssignment(CGstateassignment handle, CGbool b);
PSGLFX_EXPORT CGbool cgSetStringStateAssignment(CGstateassignment handle, const char *s);
PSGLFX_EXPORT CGbool cgSetProgramStateAssignment(CGstateassignment handle, CGprogram program);
PSGLFX_EXPORT CGbool cgSetSamplerStateAssignment(CGstateassignment handle, CGparameter sampler);
PSGLFX_EXPORT CGbool cgSetFloatArrayStateAssignment(CGstateassignment handle, const float *f);
PSGLFX_EXPORT CGbool cgSetIntArrayStateAssignment(CGstateassignment handle, const int *i);
PSGLFX_EXPORT CGbool cgSetBoolArrayStateAssignment(CGstateassignment handle, const CGbool *b);

/* Annotations */
PSGLFX_EXPORT CGbool cgSetFloatAnnotation(CGannotation handle, float f);
PSGLFX_EXPORT CGbool cgSetIntAnnotation(CGannotation handle, int i);
PSGLFX_EXPORT CGbool cgSetBoolAnnotation(CGannotation handle, CGbool b);
PSGLFX_EXPORT CGbool cgSetStringAnnotation(CGannotation handle, const char *s);
PSGLFX_EXPORT CGbool cgSetFloatArrayAnnotation(CGannotation handle, const float *f);
PSGLFX_EXPORT CGbool cgSetIntArrayAnnotation(CGannotation handle, const int *i);
PSGLFX_EXPORT CGbool cgSetBoolArrayAnnotation(CGannotation handle, const CGbool *b);

/* Parameters */
PSGLFX_EXPORT CGannotation cgCreateParameterAnnotation(CGparameter handle, const char *name, CGtype type);
PSGLFX_EXPORT CGannotation cgCreateArrayParameterAnnotation(CGparameter handle, const char *name, CGtype type, int nelems);

/* Programs */
PSGLFX_EXPORT CGannotation cgCreateProgramAnnotation(CGprogram handle, const char *name, CGtype type);
PSGLFX_EXPORT CGannotation cgCreateArrayProgramAnnotation(CGprogram handle, const char *name, CGtype type, int nelems);

/* States */
PSGLFX_EXPORT const char *cgGetStateEnumerantName(CGstate, int value);
PSGLFX_EXPORT int cgGetStateEnumerantValue(CGstate, const char *name);

#ifdef __cplusplus
}
#endif

#endif
