/* SCE CONFIDENTIAL
 * PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
 *                Copyright (C) 2006 Sony Computer Entertainment Inc.
 *                                               All Rights Reserved.
 */

#ifndef _EXPERIMENTS_H_
#define _EXPERIMENTS_H_

// Notice on combining experiments
// There are limitations on how to combine experiments
//
// GL_EXPERIMENT_NOCOMBINE_* cannot be combined with other experiments that have the same NOCOMBINE name
// GL_EXPERIMENT_COUNT_*     can be used only 1 per clock domain
// GL_EXPERIMENT_INC_*       can be used up to 4 per clock domain, unless there is a COUNT experiment in that clock domain too
//                           which means only 2 INC experiments can be used in that clock domain.
// GL_EXPERIMENT_ELAPED_*    can be used without restrictions
// GL_EXPERIMENT_GETREPORT_* can be used without restrictions

// Type masks
#define GL_EXPERIMENT_TYPE_MASK_SCE                                   0x00000F00
#define GL_EXPERIMENT_TYPE_ELAPSED_SCE                                0x00000100
#define GL_EXPERIMENT_TYPE_GET_REPORT_SCE                             0x00000200
#define GL_EXPERIMENT_TYPE_INC_SCE                                    0x00000300
#define GL_EXPERIMENT_TYPE_COUNT_SCE                                  0x00000400
#define GL_EXPERIMENT_TYPE_NOCOMBINE_SCE                              0x00000700

// Domain masks
#define GL_EXPERIMENT_CLOCK_DOMAIN_MASK_SCE                           0x0000F000
#define GL_EXPERIMENT_CLOCK_DOMAIN_H_SCE                              0x00001000
#define GL_EXPERIMENT_CLOCK_DOMAIN_G_SCE                              0x00002000
#define GL_EXPERIMENT_CLOCK_DOMAIN_S_SCE                              0x00003000
#define GL_EXPERIMENT_CLOCK_DOMAIN_R_SCE                              0x00004000
#define GL_EXPERIMENT_CLOCK_DOMAIN_M_SCE                              0x00005000

// Host clock domain
#define GL_EXPERIMENT_ELAPSED_HCLKS_SCE                               0xE0001101

// Geometry clock domain
#define GL_EXPERIMENT_ELAPSED_GCLKS_SCE                               0xE000214A
#define GL_EXPERIMENT_COUNT_PRIMITIVE_COUNT_SCE                       0xE0002402
#define GL_EXPERIMENT_COUNT_RASTERISE_PIXEL_COUNT_SCE                 0xE0002403
#define GL_EXPERIMENT_INC_ATR2CAS_ACTIVE_SCE                          0xE0002304
#define GL_EXPERIMENT_INC_ATR2CAS_STALLING_SCE                        0xE0002305
#define GL_EXPERIMENT_INC_CAS2STRI_ACTIVE_SCE                         0xE0002306
#define GL_EXPERIMENT_INC_CAS2STRI_STALLING_SCE                       0xE0002307
#define GL_EXPERIMENT_INC_CLIPID2SQD_STALLING_SCE                     0xE0002308
#define GL_EXPERIMENT_INC_CRASTER_OUTPUT_TILE_COUNT_SCE               0xE0002309
#define GL_EXPERIMENT_INC_CRSTR2CAS_STALLING_SCE                      0xE000230A
#define GL_EXPERIMENT_INC_CRSTR2ZCULL_ACTIVE_SCE                      0xE000230B
#define GL_EXPERIMENT_INC_CRSTR2ZCULL_STALLING_SCE                    0xE000230C
#define GL_EXPERIMENT_INC_DATA_STALL_VPE0_0_SCE                       0xE000230D
#define GL_EXPERIMENT_INC_DATA_STALL_VPE0_1_SCE                       0xE000230E
#define GL_EXPERIMENT_INC_DATA_STALL_VPE0_2_SCE                       0xE000230F
#define GL_EXPERIMENT_INC_FE2IDX_ACTIVE_SCE                           0xE0002310
#define GL_EXPERIMENT_INC_FE2IDX_STALLING_SCE                         0xE0002311
#define GL_EXPERIMENT_INC_FIFO_IS_FULL_STALL_SCE                      0xE0002312
#define GL_EXPERIMENT_INC_IDX2VAB_CMD_ACTIVE_SCE                      0xE0002313
#define GL_EXPERIMENT_INC_IDX2VAB_CMD_STALLING_SCE                    0xE0002314
#define GL_EXPERIMENT_INC_IDX2VAB_DIN_ACTIVE_SCE                      0xE0002315
#define GL_EXPERIMENT_INC_IDX2VAB_DIN_STALLING_SCE                    0xE0002316
#define GL_EXPERIMENT_INC_IDX_DIN_STALLING_SCE                        0xE0002317
#define GL_EXPERIMENT_INC_IDX_DMA_STALLING_SCE                        0xE0002318
#define GL_EXPERIMENT_COUNT_IDX_POST_TRANSFORM_CACHE_HIT_SCE          0xE0002419
#define GL_EXPERIMENT_COUNT_IDX_POST_TRANSFORM_CACHE_MISS_SCE         0xE000241A
#define GL_EXPERIMENT_COUNT_IDX_VERTEX_COUNT_SCE                      0xE000241B
#define GL_EXPERIMENT_COUNT_IDX_VTX_CACHE_HIT_SCE                     0xE000241C
#define GL_EXPERIMENT_COUNT_IDX_VTX_CACHE_MISS_SCE                    0xE000241D
#define GL_EXPERIMENT_INC_INSTRUCTION_ISSUED_VPE0_SCE                 0xE000231E
#define GL_EXPERIMENT_INC_SETUP2RASTER_ACTIVE_SCE                     0xE000231F
#define GL_EXPERIMENT_INC_SETUP2RASTER_STALLING_SCE                   0xE0002320
#define GL_EXPERIMENT_INC_SETUP_CULLS_SCE                             0xE0002321
#define GL_EXPERIMENT_INC_SETUP_LINES_SCE                             0xE0002322
#define GL_EXPERIMENT_INC_SETUP_POINTS_SCE                            0xE0002323
#define GL_EXPERIMENT_INC_SETUP_TRIANGLES_SCE                         0xE0002324
#define GL_EXPERIMENT_INC_VPC2STP_STALLING_SCE                        0xE0002325
#define GL_EXPERIMENT_INC_VPC_CULL_PRIMITIVE_SCE                      0xE0002326
#define GL_EXPERIMENT_INC_ZCULL2FRSTR_STALLING_SCE                    0xE0002327
#define GL_EXPERIMENT_NOCOMBINE_COUNT_ZCULL_TILES_TOTAL_CULLED_SCE    0xE0002728
#define GL_EXPERIMENT_NOCOMBINE_COUNT_ZCULL_Z_ACCEPTED_COUNT_SCE      0xE0002729
#define GL_EXPERIMENT_NOCOMBINE_COUNT_ZCULL_Z_REJECTED_COUNT_SCE      0xE000272A
#define GL_EXPERIMENT_NOCOMBINE_COUNT_ZCULL_STENCIL_CULLED_COUNT_SCE  0xE000272B

// Shader clock domain
#define GL_EXPERIMENT_ELAPSED_SCLKS_SCE                               0xE000312C
#define GL_EXPERIMENT_INC_SHADER_NUM_PASSES_SCE                       0xE000332D
#define GL_EXPERIMENT_INC_MCACHE_SET0_MISS_COUNT_SCE                  0xE000332E
#define GL_EXPERIMENT_INC_MCACHE_SET1_MISS_COUNT_SCE                  0xE000332F
#define GL_EXPERIMENT_INC_MCACHE_SET2_MISS_COUNT_SCE                  0xE0003330
#define GL_EXPERIMENT_INC_MCACHE_SET3_MISS_COUNT_SCE                  0xE0003331
#define GL_EXPERIMENT_INC_MCACHE_SET4_MISS_COUNT_SCE                  0xE0003332
#define GL_EXPERIMENT_INC_RASTER_2D_WAITS_FOR_SHADER_SCE              0xE0003333
#define GL_EXPERIMENT_INC_SCT2TEX_ACTIVE_SCE                          0xE0003334
#define GL_EXPERIMENT_INC_SCT2TEX_STALLING_SCE                        0xE0003335
#define GL_EXPERIMENT_INC_SHADER_ALL_QUADS_SCE                        0xE0003336
#define GL_EXPERIMENT_INC_SHADER_ALL_KILL_QUADS_SCE                   0xE0003337
#define GL_EXPERIMENT_INC_SQC2PROP_STALLING_SCE                       0xE0003338
#define GL_EXPERIMENT_INC_SQC2PROP_STARVING_SCE                       0xE0003339
#define GL_EXPERIMENT_INC_SQD2SQC_STALLING_SCE                        0xE000333A
#define GL_EXPERIMENT_INC_SQD2SQC_STARVING_SCE                        0xE000333B
#define GL_EXPERIMENT_INC_STRI2SQD_STALLING_SCE                       0xE000333C
#define GL_EXPERIMENT_INC_TEX2SRB_STALLING_SCE                        0xE000333D
#define GL_EXPERIMENT_INC_TEXTURE_FOOTPRINT_COUNT_SCE                 0xE000333E
#define GL_EXPERIMENT_INC_PROP2CBUF_STALLING_SCE                      0xE0003348
#define GL_EXPERIMENT_INC_PROP2CBUF_STARVING_SCE                      0xE0003349
#define GL_EXPERIMENT_NOCOMBINE_INC_PREROP_ALPHATEST_KILL_SCE         0xE0003743
#define GL_EXPERIMENT_NOCOMBINE_INC_PREROP_BLENDOPT_KILL_SCE          0xE0003744
#define GL_EXPERIMENT_NOCOMBINE_INC_PREROP_ITERATED_KILL_SCE          0xE0003745
#define GL_EXPERIMENT_NOCOMBINE_INC_PREROP_NO_KILL_SCE                0xE0003746
#define GL_EXPERIMENT_NOCOMBINE_INC_PREROP_ZCLIP_KILL_SCE             0xE0003747

// Framebuffer clock domain
#define GL_EXPERIMENT_ELAPSED_MCLKS_SCE                               0xE000513F
#define GL_EXPERIMENT_INC_FB_DRAM_ACT_1ST_SCE                         0xE0005340
#define GL_EXPERIMENT_INC_FB_DRAM_ACT_2ND_SCE                         0xE0005341

// ROP clock domain
#define GL_EXPERIMENT_ELAPSED_RCLKS_SCE                               0xE0004142


// Generic stop counter

#define GL_EXPERIMENT_STOP_QUERY_SCE                                  0xE000FFFF

#endif // _EXPERIMENTS_H_
