/* SCE CONFIDENTIAL
 * PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
 *                Copyright (C) 2006 Sony Computer Entertainment Inc.
 *                                               All Rights Reserved.
 */
#ifndef _PSGL_h
#define _PSGL_h

#include <stdlib.h>
#include <PSGL/export.h>
#include <GLES/gl.h>
#include <GLES/glext.h>
#include <Cg/cg.h>
#include <Cg/cgGL.h>
#include <PSGL/report.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct PSGLdevice PSGLdevice;
typedef struct PSGLcontext PSGLcontext;

typedef enum PSGLdeviceType
{
	PSGL_DEVICE_TYPE_AUTO,
	PSGL_DEVICE_TYPE_WINDOW,
	PSGL_DEVICE_TYPE_VGA,
	PSGL_DEVICE_TYPE_DFP,
	PSGL_DEVICE_TYPE_TV
} PSGLdeviceType;

typedef enum PSGLtvStandard
{
	PSGL_TV_STANDARD_NONE,
	PSGL_TV_STANDARD_NTSC_M,
	PSGL_TV_STANDARD_NTSC_J,
	PSGL_TV_STANDARD_PAL_M,
	PSGL_TV_STANDARD_PAL_B,
	PSGL_TV_STANDARD_PAL_D,
	PSGL_TV_STANDARD_PAL_G,
	PSGL_TV_STANDARD_PAL_H,
	PSGL_TV_STANDARD_PAL_I,
	PSGL_TV_STANDARD_PAL_N,
	PSGL_TV_STANDARD_PAL_NC,
	PSGL_TV_STANDARD_HD480I,
	PSGL_TV_STANDARD_HD480P,
	PSGL_TV_STANDARD_HD576I,
	PSGL_TV_STANDARD_HD576P,
	PSGL_TV_STANDARD_HD720P,
	PSGL_TV_STANDARD_HD1080I,
	PSGL_TV_STANDARD_HD1080P,
	PSGL_TV_STANDARD_1280x720_ON_VESA_1280x768=128,
	PSGL_TV_STANDARD_1280x720_ON_VESA_1280x1024,
	PSGL_TV_STANDARD_1920x1080_ON_VESA_1920x1200,
} PSGLtvStandard;

typedef enum PSGLtvFormat
{
	PSGL_TV_FORMAT_AUTO,
	PSGL_TV_FORMAT_COMPOSITE,
	PSGL_TV_FORMAT_SVIDEO,
	PSGL_TV_FORMAT_YCRCB,
	PSGL_TV_FORMAT_YPRPB,
} PSGLtvFormat;

typedef enum PSGLbufferingMode
{
	PSGL_BUFFERING_MODE_SINGLE = 1,
	PSGL_BUFFERING_MODE_DOUBLE = 2,
	PSGL_BUFFERING_MODE_TRIPLE = 3,
} PSGLbufferingMode;

typedef struct
{
	GLint width;
	GLint height;
	GLint colorBits;
	GLint alphaBits;
	GLint depthBits;
	GLint stencilBits;
	GLenum deviceType;
	GLenum TVStandard;
	GLenum TVFormat;
	GLenum bufferingMode;
	GLboolean antiAliasing;
} PSGLbufferParameters;

typedef enum PSGLdeviceConnector
{
	PSGL_DEVICE_CONNECTOR_NONE,
	PSGL_DEVICE_CONNECTOR_VGA,
	PSGL_DEVICE_CONNECTOR_DVI,
	PSGL_DEVICE_CONNECTOR_HDMI,
	PSGL_DEVICE_CONNECTOR_COMPOSITE,
	PSGL_DEVICE_CONNECTOR_SVIDEO,
	PSGL_DEVICE_CONNECTOR_COMPONENT,
} PSGLdeviceConnector;

#define PSGL_DEVICE_PARAMETERS_COLOR_FORMAT       0x0001
#define PSGL_DEVICE_PARAMETERS_DEPTH_FORMAT       0x0002
#define PSGL_DEVICE_PARAMETERS_MULTISAMPLING_MODE 0x0004
#define PSGL_DEVICE_PARAMETERS_TV_STANDARD        0x0008
#define PSGL_DEVICE_PARAMETERS_CONNECTOR          0x0010
#define PSGL_DEVICE_PARAMETERS_BUFFERING_MODE     0x0020
#define PSGL_DEVICE_PARAMETERS_WIDTH_HEIGHT       0x0040

typedef struct
{
	GLuint enable;
	GLenum colorFormat;
	GLenum depthFormat;
	GLenum multisamplingMode;
	PSGLtvStandard TVStandard;
	PSGLdeviceConnector connector;
	GLenum bufferingMode;
	GLuint width;
	GLuint height;
} PSGLdeviceParameters;

#define	PSGL_INIT_MAX_SPUS				0x0001
#define	PSGL_INIT_INITIALIZE_SPUS			0x0002
#define	PSGL_INIT_PERSISTENT_MEMORY_SIZE	0x0004
#define	PSGL_INIT_TRANSIENT_MEMORY_SIZE	0x0008
#define	PSGL_INIT_ERROR_CONSOLE			0x0010
#define	PSGL_INIT_FIFO_SIZE				0x0020
#define	PSGL_INIT_HOST_MEMORY_SIZE			0x0040
#define PSGL_INIT_USE_PMQUERIES           0x0080

typedef struct PSGLinitOptions
{
	GLuint			enable;	// bitfield of options to set
	GLuint 			maxSPUs;
	GLboolean		initializeSPUs;
	GLuint			persistentMemorySize;
	GLuint			transientMemorySize;
	int				errorConsole;
	GLuint			fifoSize;
	GLuint			hostMemorySize;
} PSGLinitOptions;

typedef unsigned long long int PSGLuint64;

typedef void* (*PSGLmallocFunc)(size_t LSize);		// expected to return 16-byte aligned
typedef void* (*PSGLmemalignFunc)(size_t align, size_t LSize);
typedef void* (*PSGLreallocFunc)(void* LBlock, size_t LSize);
typedef void  (*PSGLfreeFunc)(void* LBlock);

extern PSGL_EXPORT void	psglInit(PSGLinitOptions* options);
extern PSGL_EXPORT void	psglExit();

PSGL_EXPORT PSGLdevice*	psglCreateDevice(const PSGLbufferParameters* params) PSGL_DEPRECATED;
PSGL_EXPORT const PSGLbufferParameters *psglGetDeviceBufferParameters(const PSGLdevice * device) PSGL_DEPRECATED;

PSGL_EXPORT PSGLdevice*	psglCreateDeviceAuto(GLenum colorFormat, GLenum depthFormat, GLenum multisamplingMode);
PSGL_EXPORT PSGLdevice*	psglCreateDeviceExtended(const PSGLdeviceParameters *parameters);
PSGL_EXPORT void psglGetDeviceDimensions(const PSGLdevice * device, GLuint *width, GLuint *height);
PSGL_EXPORT void psglDestroyDevice(PSGLdevice* device);

PSGL_EXPORT void psglMakeCurrent(PSGLcontext* context, PSGLdevice* device);
PSGL_EXPORT PSGLcontext* psglCreateContext();
PSGL_EXPORT void psglDestroyContext(PSGLcontext* LContext);
PSGL_EXPORT void psglResetCurrentContext();
PSGL_EXPORT PSGLcontext* psglGetCurrentContext();
PSGL_EXPORT PSGLdevice* psglGetCurrentDevice();
PSGL_EXPORT void psglSwap(void);

PSGL_EXPORT void psglLoadShaderLibrary(const char *filename);

PSGL_EXPORT PSGLuint64 psglGetSystemTime();
PSGL_EXPORT void* psglGetSPUInitData(void);

PSGL_EXPORT GLboolean psglSetAllocatorFuncs( PSGLmallocFunc mallocFunc, PSGLmemalignFunc memalignFunc, PSGLreallocFunc reallocFunc, PSGLfreeFunc freeFunc );

#ifdef __cplusplus
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif
