/*   SCE CONFIDENTIAL                                        */
/* PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006 */
/*   Copyright (C) 2006 Sony Computer Entertainment Inc.     */
/*   All Rights Reserved.                                    */
#ifndef __LIBFONT_H__
#define __LIBFONT_H__

#include <types.h>
#include <cellstatus.h>
#include <cell/error.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


typedef void* (*CellFontMallocCallback)( void*Object, uint32_t size );
typedef void  (*CellFontFreeCallback)( void*Object, void*free_address );
typedef void* (*CellFontReallocCallback)( void*Object, void*p, uint32_t reallocSize );
typedef void* (*CellFontCallocCallback)( void*Object, uint32_t num, uint32_t size );
typedef struct CellFontMemoryInterface
{
	void* Object;
	CellFontMallocCallback  Malloc;
	CellFontFreeCallback    Free;
	CellFontReallocCallback Realloc;
	CellFontCallocCallback  Calloc;
	
} CellFontMemoryInterface;

static inline void CellFontMemoryInterface_initialize( CellFontMemoryInterface*mIF )
{
	mIF->Object = (void*)0;
	mIF->Malloc  = (CellFontMallocCallback )0;
	mIF->Free    = (CellFontFreeCallback   )0;
	mIF->Realloc = (CellFontReallocCallback)0;
	mIF->Calloc  = (CellFontCallocCallback )0;
}


typedef struct CellFontEntry
{
	uint32_t lock;
	uint32_t uniqueId;
	const void* fontLib;
	void*    fontH;

} CellFontEntry;

typedef struct CellFontConfig
{
	struct {
		uint32_t* buffer;
		uint32_t  size;
	} FileCache;

	uint32_t       userFontEntryMax;
	CellFontEntry* userFontEntrys;

	uint32_t flags;
} CellFontConfig;

static inline void CellFontConfig_initialize( CellFontConfig* config )
{
	config->FileCache.buffer = (uint32_t*)0;
	config->FileCache.size   = 0;
	config->userFontEntryMax = 0;
	config->userFontEntrys = (CellFontEntry*)0;
	config->flags = 0x00000000;
}


typedef struct CellFontLibrary
{
	uint32_t libraryType, libraryVersion;
	void* SystemReserve[32];
	
} CellFontLibrary;

#define CELL_FONT_LIBRARY_TYPE_NONE (0)

typedef struct CellFontType
{
	uint32_t type;
	uint32_t map;
	
} CellFontType;


typedef struct CellFontHorizontalLayout
{
	float baseLineY;
	float lineHeight;

} CellFontHorizontalLayout;

typedef struct CellFontVerticalLayout
{
	float baseLineX;
	float lineWidth;

} CellFontVerticalLayout;


typedef struct CellFontGlyphMetrics
{
	float width;
	float height;

	struct {
		float bearingX;
		float bearingY;
		float advance;
	} Horizontal;
	struct {
		float bearingX;
		float bearingY;
		float advance;
	} Vertical;

} CellFontGlyphMetrics;


typedef struct CellFontRenderSurface
{
	void* buffer;
	int32_t widthByte;
	int32_t pixelSizeByte;
	int32_t width, height;
	struct {
		uint32_t x0, y0;
		uint32_t x1, y1;
	} Scissor;

} CellFontRenderSurface;

typedef struct CellFontImageTransInfo
{
	uint8_t *Image;
	uint32_t imageWidthByte;
	uint32_t imageWidth;
	uint32_t imageHeight;
	void *Surface;
	uint32_t surfWidthByte;

} CellFontImageTransInfo;


typedef struct CellFont
{
	void* SystemReserved[64];

} CellFont;

typedef struct CellFontRendererConfig
{
	struct {
		void*        buffer;
		uint32_t   initSize;
		uint32_t    maxSize;
		uint32_t expandSize;
		uint32_t  resetSize;
	} BufferingPolicy;

} CellFontRendererConfig;

static inline void CellFontRendererConfig_initialize( CellFontRendererConfig* config )
{
	config->BufferingPolicy.buffer = (void*)0;
	config->BufferingPolicy.initSize = 0;
	config->BufferingPolicy.maxSize  = 0;
	config->BufferingPolicy.expandSize = 1;
	config->BufferingPolicy.resetSize  = 0;
}
#if 0
static inline void CellFontRendererConfig_setStaticBuffer(
                   CellFontRendererConfig* config, void* buf, uint32_t size )
{
	config->BufferingPolicy.buffer = buf;
	config->BufferingPolicy.initSize = size;
	config->BufferingPolicy.maxSize  = size;
	config->BufferingPolicy.expandSize = 0;
	config->BufferingPolicy.resetSize  = 0;
}
#endif
static inline void CellFontRendererConfig_setAllocateBuffer(
                   CellFontRendererConfig* config, uint32_t initSize, uint32_t maxSize )
{
	config->BufferingPolicy.buffer = (void*)0;
	config->BufferingPolicy.initSize = initSize;
	config->BufferingPolicy.maxSize  = maxSize;
	config->BufferingPolicy.expandSize = 1;
	config->BufferingPolicy.resetSize  = 0;
}

typedef struct CellFontRenderer
{
	void* Render_work;
	void* lib;
	
	struct {
		uint32_t hDpi, vDpi;
		float widthPoint, heightPoint;
		float widthPixel, heightPixel;
	} Scale;
	
} CellFontRenderer;


int cellFontInit( CellFontConfig* );

//int cellFontInitLibrary( CellFontLibraryConfig*, const CellFontLibrary**lib );

int cellFontOpenFontset( const CellFontLibrary*, CellFontType*, CellFont* );
int cellFontOpenFontFile( const CellFontLibrary*,
                          uint8_t* fontPath, uint32_t subNum, int32_t uniqueID, CellFont* );
int cellFontOpenFontMemory( const CellFontLibrary*,
                            void* fontAddr, uint32_t fontSize, uint32_t subNum, int32_t uniqueID, CellFont* );

int cellFontOpenFontInstance( CellFont*org, CellFont*ins );

int cellFontGetLibrary( CellFont*cf, const CellFontLibrary**lib, uint32_t* type );

int cellFontSetResolutionDpi( CellFont*, uint32_t hDpi, uint32_t vDpi );
int cellFontSetScalePoint( CellFont*, float w, float h );
int cellFontSetScalePixel( CellFont*, float w, float h );

int cellFontGetHorizontalLayout( CellFont*, CellFontHorizontalLayout* layout );
int cellFontGetVerticalLayout( CellFont*, CellFontVerticalLayout* layout );

int cellFontGetFontIdCode( CellFont*, uint32_t code, uint32_t*fontId, uint32_t*fontcode );

int cellFontGetCharGlyphMetrics( CellFont*, uint32_t code, CellFontGlyphMetrics* );

int cellFontCreateRenderer( const CellFontLibrary* lib, 
                            CellFontRendererConfig* confing, CellFontRenderer* renderer );

int cellFontBindRenderer( CellFont*, CellFontRenderer* );

int cellFontSetupRenderScalePoint( CellFont*, float w, float h );
int cellFontSetupRenderScalePixel( CellFont*, float w, float h );
int cellFontGetRenderCharGlyphMetrics( CellFont*, uint32_t code, CellFontGlyphMetrics* );

void cellFontRenderSurfaceInit( CellFontRenderSurface*,
                                void* buffer, int bufWidthByte, int pixelSizeByte,
                                int w, int h );
void cellFontRenderSurfaceSetScissor( CellFontRenderSurface*,
                                      int x0, int y0, uint32_t w, uint32_t h );

int cellFontRenderCharGlyphImage( CellFont*, uint32_t code,
                                  CellFontRenderSurface*, float x, float y,
                                  CellFontGlyphMetrics*, CellFontImageTransInfo* );

int cellFontRenderCharGlyphImageHorizontal( CellFont*, uint32_t code,
                                  CellFontRenderSurface*, float x, float y,
                                  CellFontGlyphMetrics*, CellFontImageTransInfo* );

int cellFontRenderCharGlyphImageVertical( CellFont*, uint32_t code,
                                  CellFontRenderSurface*, float x, float y,
                                  CellFontGlyphMetrics*, CellFontImageTransInfo* );

int cellFontUnbindRenderer( CellFont* );

int cellFontDestroyRenderer( CellFontRenderer* renderer );

int cellFontCloseFont( CellFont*cf );

int cellFontEndLibrary( const CellFontLibrary*lib );

int cellFontEnd(void);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __LIBFONT_H__ */



