/*   SCE CONFIDENTIAL                                       */
/*   PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006 */
/*   Copyright (C) 2006 Sony Computer Entertainment Inc.    */
/*   All Rights Reserved.                                   */

#ifndef __CELL_FS_CELL_FS_FILE_API_H__
#define __CELL_FS_CELL_FS_FILE_API_H__

#include <sys/fs.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

CellFsErrno cellFsOpen(const char *path, int flags, int *fd, const void *arg, uint64_t size);
CellFsErrno cellFsRead(int fd, void *buf, uint64_t nbytes, uint64_t *nread);
CellFsErrno cellFsWrite(int fd, const void *buf, uint64_t nbytes, uint64_t *nwrite);
CellFsErrno cellFsClose(int fd);
CellFsErrno cellFsOpendir(const char *path, int *fd);
CellFsErrno cellFsReaddir(int fd, CellFsDirent *dir, uint64_t *nread);
CellFsErrno cellFsClosedir(int fd);
CellFsErrno cellFsStat(const char *path, CellFsStat *sb);
CellFsErrno cellFsFstat(int fd, CellFsStat *sb);
CellFsErrno cellFsMkdir(const char *path, CellFsMode mode);
CellFsErrno cellFsRename(const char *from, const char *to);
CellFsErrno cellFsRmdir(const char *path);
CellFsErrno cellFsUnlink(const char *path);
CellFsErrno cellFsLseek(int fd, int64_t offset, int whence, uint64_t *pos);
CellFsErrno cellFsFsync(int fd);

CellFsErrno cellFsFGetBlockSize(int fd, uint64_t *sector_size,
                uint64_t *block_size);
CellFsErrno cellFsGetBlockSize(const char *path, uint64_t *sector_size,
                uint64_t *block_size);

CellFsErrno cellFsTruncate(const char *path, uint64_t size);
CellFsErrno cellFsFtruncate(int fd, uint64_t size);

#ifdef __cplusplus
}
#endif /* __cplusplus */

/* CellFsRingBuffer.copy */
#define CELL_FS_ST_COPY             0
#define CELL_FS_ST_COPYLESS         1

/* CellFsRingBuffer */
typedef struct CellFsRingBuffer
{
  uint64_t ringbuf_size;
  uint64_t block_size;
  uint64_t transfer_rate;
  int copy;
} CellFsRingBuffer;

/* return value of status cellFsSt{Read,Write}GetStatus */
#define CELL_FS_ST_INITIALIZED      0x0001
#define CELL_FS_ST_NOT_INITIALIZED  0x0002
#define CELL_FS_ST_STOP             0x0100
#define CELL_FS_ST_PROGRESS         0x0200

/* APIs */
#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

CellFsErrno cellFsStReadInit(int fd, const CellFsRingBuffer *ringbuf);
CellFsErrno cellFsStReadFinish(int fd);
CellFsErrno cellFsStReadGetRingBuf(int fd, CellFsRingBuffer *ringbuf);
CellFsErrno cellFsStReadGetStatus(int fd, uint64_t *status);
CellFsErrno cellFsStReadGetRegid(int fd, uint64_t *regid);
CellFsErrno cellFsStReadStart(int fd, uint64_t offset, uint64_t size);
CellFsErrno cellFsStReadStop(int fd);
CellFsErrno cellFsStRead(int fd, char *buf, uint64_t size, uint64_t *rsize);
CellFsErrno cellFsStReadGetCurrentAddr(int fd, char **addr, uint64_t *size);
CellFsErrno cellFsStReadPutCurrentAddr(int fd, char *addr, uint64_t size);
CellFsErrno cellFsStReadWait(int fd, uint64_t size);
CellFsErrno cellFsStReadWaitCallback(int fd, uint64_t size, void (*func)(int xfd, uint64_t xsize));

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __CELL_FS_CELL_FS_FILE_API_H__ */

