/*   SCE CONFIDENTIAL                                       */
/*   PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006 */
/*   Copyright (C) 2006 Sony Computer Entertainment Inc.    */
/*   All Rights Reserved.                                   */
#ifndef __CELL_PAD_PAD_CODES_H__
#define __CELL_PAD_PAD_CODES_H__

#include <sys/types.h>

#define CELL_MAX_PADS 127
#define CELL_PAD_MAX_CODES 64

/*E CellPadInfo : common information of game pad. */
#define CELL_PAD_INFO_INTERCEPTED		(1 << 0) /*E input intercepted */

/*E CellPadInfo : connected status.  */
#define CELL_PAD_STATUS_CONNECTED		(1)	/*E Game Pad is connected.    */
#define CELL_PAD_STATUS_DISCONNECTED	(0) /*E Game Pad is disconnected  */

typedef struct CellPadInfo{
  uint32_t max_connect;
  uint32_t now_connect;
  uint32_t info;
  uint16_t vendor_id[CELL_MAX_PADS];
  uint16_t product_id[CELL_MAX_PADS];
  uint8_t status[CELL_MAX_PADS];
}CellPadInfo;

/*E CellPadData : Byte offset of button data.  */
typedef enum CellPadButtonDataOffset{
	CELL_PAD_BTN_OFFSET_DIGITAL1 = 2,
	CELL_PAD_BTN_OFFSET_DIGITAL2 = 3,
	CELL_PAD_BTN_OFFSET_ANALOG_RIGHT_X = 4,
	CELL_PAD_BTN_OFFSET_ANALOG_RIGHT_Y = 5,
	CELL_PAD_BTN_OFFSET_ANALOG_LEFT_X  = 6,
	CELL_PAD_BTN_OFFSET_ANALOG_LEFT_Y  = 7,
	CELL_PAD_BTN_OFFSET_PRESS_RIGHT    = 8,
	CELL_PAD_BTN_OFFSET_PRESS_LEFT     = 9,
	CELL_PAD_BTN_OFFSET_PRESS_UP       = 10,
	CELL_PAD_BTN_OFFSET_PRESS_DOWN     = 11,
	CELL_PAD_BTN_OFFSET_PRESS_TRIANGLE = 12,
	CELL_PAD_BTN_OFFSET_PRESS_CIRCLE   = 13,
	CELL_PAD_BTN_OFFSET_PRESS_CROSS    = 14,
	CELL_PAD_BTN_OFFSET_PRESS_SQUARE   = 15,
	CELL_PAD_BTN_OFFSET_PRESS_L1       = 16,
	CELL_PAD_BTN_OFFSET_PRESS_R1       = 17,
	CELL_PAD_BTN_OFFSET_PRESS_L2       = 18,
	CELL_PAD_BTN_OFFSET_PRESS_R2       = 19,
}CellPadButtonDataOffset;

/*E CellPadData : Bit assignment of digital buttons. */
/*E "CELL_PAD_BTN_OFFSET_DIGITAL1" assignment */
#define CELL_PAD_CTRL_LEFT		(1 << 7)
#define CELL_PAD_CTRL_DOWN		(1 << 6)
#define CELL_PAD_CTRL_RIGHT		(1 << 5)
#define CELL_PAD_CTRL_UP		(1 << 4)
#define CELL_PAD_CTRL_START		(1 << 3)
#define CELL_PAD_CTRL_R3		(1 << 2)
#define CELL_PAD_CTRL_L3		(1 << 1)
#define CELL_PAD_CTRL_SELECT	(1 << 0)

/*E "CELL_PAD_BTN_OFFSET_DIGITAL2" assignment */
#define CELL_PAD_CTRL_SQUARE	(1 << 7)
#define CELL_PAD_CTRL_CROSS		(1 << 6)
#define CELL_PAD_CTRL_CIRCLE	(1 << 5)
#define CELL_PAD_CTRL_TRIANGLE	(1 << 4)
#define CELL_PAD_CTRL_R1		(1 << 3)
#define CELL_PAD_CTRL_L1		(1 << 2)
#define CELL_PAD_CTRL_R2		(1 << 1)
#define CELL_PAD_CTRL_L2		(1 << 0)

typedef struct CellPadData{
  int32_t len;
  uint8_t button[CELL_PAD_MAX_CODES];
}CellPadData;

/*E cellPadSetPressMode parameter */
#define CELL_PAD_PRESS_MODE_OFF 	(0)
#define CELL_PAD_PRESS_MODE_ON		(1)

#define CELL_PAD_INFO_SUPPORTED_PRESS_MODE (1)

#endif /*  __CELL_PAD_PAD_CODES_H__ */

