/* SCE CONFIDENTIAL
PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
 * Copyright (C) 2006 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */

#ifndef __CELL_SPURS_EXCEPTION_H__
#define __CELL_SPURS_EXCEPTION_H__

#ifdef __cplusplus
extern "C" {
#endif

/* The C Standard Library */
#include <stdint.h>
#include <stdbool.h>
#include <sys/types.h> /* sys_spu_thread_t */

/* SPURS */
#include <cell/spurs/types.h>			/* CellSpurs, CellSpursWorkloadId */
#include <cell/spurs/error.h>

/* size: 24 bytes */
typedef struct CellSpursExceptionInfo {
#ifndef __linux__
	sys_spu_thread_t spu_thread;
#else /* __linux__ */
	uint32_t spu_thread; /* FIXME: */
#endif /* __linux__ */
	uint32_t spu_npc;
	uint32_t cause;
	/* padding 4 bytes */
	uint64_t option;
} CellSpursExceptionInfo;

typedef void (*CellSpursExceptionEventHandler)(
		CellSpurs*,
		const CellSpursExceptionInfo*,
		void*
	);

int cellSpursEnableExceptionEventHandler(CellSpurs* spurs, bool flag);
int cellSpursSetExceptionEventHandler(
		CellSpurs* spurs,
		CellSpursWorkloadId id,
		CellSpursExceptionEventHandler eaHandler,
		void* arg
	);

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __CELL_SPURS_EXCEPTION_H__ */

