/* SCE CONFIDENTIAL
   PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
   * Copyright (C) 2006 Sony Computer Entertainment Inc.
   * All Rights Reserved.
   */

#ifndef __CELL_SPURS_JOB_CHAIN_H__
#define __CELL_SPURS_JOB_CHAIN_H__

#include <stdint.h>
#include <cell/spurs/error.h>
#include <cell/spurs/control.h>
#include <cell/spurs/job_descriptor.h>
#include <cell/spurs/job_commands.h>
#include <cell/spurs/job_guard.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define CELL_SPURS_JOBCHAIN_ALIGN	128
#define CELL_SPURS_JOBCHAIN_SIZE	272

	typedef struct CellSpursJobChain {
		unsigned char skip[CELL_SPURS_JOBCHAIN_SIZE];
	} CellSpursJobChain __attribute__((aligned(CELL_SPURS_JOBCHAIN_ALIGN)));

/*
 * Job Chain
 */
	int cellSpursCreateJobChain(CellSpurs *spurs,
								CellSpursJobChain* jobChain,
								const uint64_t *jobChainEntry,
								uint16_t sizeJobDescriptor,
								uint16_t maxGrabdedJob,
								const uint8_t priorityTable[8],
								unsigned int maxContention,
								bool autoReadyCount,
								unsigned int tag1,
								unsigned int tag2);
	
	int cellSpursShutdownJobChain(const CellSpursJobChain* jobChain);
	int cellSpursKickJobChain(const CellSpursJobChain* jobChain,
							  uint8_t numReadyCount);
	int cellSpursJoinJobChain(CellSpursJobChain *jobChain_);
	int cellSpursJobChainGetError(CellSpursJobChain *jobChain_, void** cause);

/*
 *  Urgent Call Registration
 */
	int cellSpursAddUrgentCall(CellSpursJobChain* jobChain,
							   uint64_t *commandList);
	int cellSpursAddUrgentCommand(CellSpursJobChain* jobChain,
								  uint64_t command);

/*
 *  SPURS Job Guard
 */
	int cellSpursJobGuardInitialize(const CellSpursJobChain* jobChain,
									CellSpursJobGuard* jobGuard,
									uint32_t notifyCount,
									uint8_t numReadyCount,
									uint8_t autoReset);
	int cellSpursJobGuardReset(CellSpursJobGuard* jobGuard);
	int cellSpursJobGuardNotify(CellSpursJobGuard* jobGuard);



#ifdef __cplusplus
} /* extern "C" */
#endif /* __cplusplus */

#endif /* __CELL_SPURS_JOB_CHAIN_H__ */

/*
 * Local Variables:
 * mode: C
 * c-file-style: "stroustrup"
 * tab-width: 4
 * End:
 * vim:sw=4:sts=4:ts=4
 */
