/* SCE CONFIDENTIAL
PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
 * Copyright (C) 2006 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */

#ifndef __CELL_SPURS_TASK_H__
#define __CELL_SPURS_TASK_H__ 1

/* The C Standard Library */
#include <stdint.h>

/* SPURS */
#include <cell/spurs/task_types.h>
#include <cell/spurs/types.h>			/* CellSpurs */
#include <cell/spurs/error.h>

#ifdef __cplusplus
extern "C" {
#endif

int cellSpursCreateTaskset(CellSpurs*,
						CellSpursTaskset*,
						uint64_t argTaskset,
						const uint8_t priority[8],
						unsigned int max_contention);

int cellSpursShutdownTaskset(CellSpursTaskset*);

int	cellSpursJoinTaskset(CellSpursTaskset*);

#ifdef __cplusplus
} /* extern "C" */
#endif

/*
 * SPURS task
 */

typedef union CellSpursTaskArgument {
	uint32_t u32[4];
	uint64_t u64[2];
} CellSpursTaskArgument;

typedef union CellSpursTaskLsPattern {
	uint32_t u32[4];
	uint64_t u64[2];
} CellSpursTaskLsPattern;

/* for convenience */
extern const CellSpursTaskLsPattern	gCellSpursTaskLsAll;

#ifdef __cplusplus
extern "C" {
#endif

int cellSpursCreateTask(CellSpursTaskset*,
						CellSpursTaskId*,
						const void *eaElf,
						const void *eaContext,
						uint32_t sizeContext,
						const CellSpursTaskLsPattern*,
						const CellSpursTaskArgument*);

int cellSpursSendSignal(CellSpursTaskset*, CellSpursTaskId);

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __CELL_SPURS_TASK_H__ */

/*
 * Local Variables:
 * mode: C
 * c-file-style: "stroustrup"
 * tab-width: 4
 * End:
 * vim:sw=4:sts=4:ts=4
 */
