/* SCE CONFIDENTIAL
PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
 * Copyright (C) 2006 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */

#ifndef __CELL_SPURS_WORKLOAD_H__
#define __CELL_SPURS_WORKLOAD_H__ 1

/* The C Standard Library */
#include <stdint.h>

/* SPURS */
#include <cell/spurs/types.h>			/* CellSpurs, CellSpursWorkloadId */
#include <cell/error.h>

#ifdef __cplusplus
extern "C" {
#endif

int cellSpursAddWorkload(CellSpurs*, CellSpursWorkloadId*,
						 const void *pm, unsigned size, const void *data, const uint8_t priorityTable[8],
						 unsigned int minContention, unsigned int maxContention);
int cellSpursShutdownWorkload(CellSpurs*, CellSpursWorkloadId);
int cellSpursWaitForWorkloadShutdown(CellSpurs*, CellSpursWorkloadId);
int cellSpursRemoveWorkload(CellSpurs*, CellSpursWorkloadId);

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __CELL_SPURS_WORKLOAD_H__ */

/*
 * Local Variables:
 * mode: C
 * c-file-style: "stroustrup"
 * tab-width: 4
 * End:
 * vim:sw=4:sts=4:ts=4
 */
