/*  SCE CONFIDENTIAL                                      */
/*  PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006 */
/*  Copyright (C) 2006 Sony Computer Entertainment Inc.   */
/*  All Rights Reserved.                                  */
#ifndef __CELL_SSL_CERT_H__
#define __CELL_SSL_CERT_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

typedef void* CellSslCert;
#define CellSslCertName void*

#define CELL_SSL_LOAD_CERT_ALL               (CELL_SSL_LOAD_CERT_SCE |   \
								              CELL_SSL_LOAD_CERT_NORMAL)
#define CELL_SSL_LOAD_CERT_SCE               (CELL_SSL_LOAD_CERT_SCE01 | \
								              CELL_SSL_LOAD_CERT_SCE02 | \
								              CELL_SSL_LOAD_CERT_SCE03 | \
								              CELL_SSL_LOAD_CERT_SCE04 | \
								              CELL_SSL_LOAD_CERT_SCE05)
#define CELL_SSL_LOAD_CERT_NORMAL            (CELL_SSL_LOAD_CERT_GTE_CT_G_RCA)

#define CELL_SSL_LOAD_CERT_SCE01             (0x0000000000000001)
#define CELL_SSL_LOAD_CERT_SCE02             (0x0000000000000002)
#define CELL_SSL_LOAD_CERT_SCE03             (0x0000000000000004)
#define CELL_SSL_LOAD_CERT_SCE04             (0x0000000000000008)
#define CELL_SSL_LOAD_CERT_SCE05             (0x0000000000000010)

#define CELL_SSL_LOAD_CERT_GTE_CT_G_RCA      (0x0000000000000020)

/* Max size for a certificate's MD5 Fingerprint */
#define CELL_SSL_MD5_FINGERPRINT_MAX_SIZE   (20)

/* SSL Certificate Get functions */
int cellSslCertGetSerialNumber(const CellSslCert sslCert, const uint8_t **sboData, size_t *sboLength);
int cellSslCertGetPublicKey(const CellSslCert sslCert, const uint8_t **sboData, size_t *sboLength);
int cellSslCertGetRsaPublicKeyModulus(const CellSslCert sslCert, const uint8_t **sboData, size_t *sboLength);
int cellSslCertGetRsaPublicKeyExponent(const CellSslCert sslCert, const uint8_t **sboData, size_t *sboLength);
int cellSslCertGetNotBefore(const CellSslCert sslCert, CellRtcTick *begin);
int cellSslCertGetNotAfter(const CellSslCert sslCert, CellRtcTick *limit);
int cellSslCertGetSubjectName(const CellSslCert sslCert, const CellSslCertName *certName);
int cellSslCertGetIssuerName(const CellSslCert sslCert, const CellSslCertName *certName);

int cellSslCertGetNameEntryCount(const CellSslCertName certName, uint32_t *entryCount);
int cellSslCertGetNameEntryInfo(const CellSslCertName certName, uint32_t entryNum, const char **oidName, const uint8_t **value, size_t *valueLength, int32_t flag);
int cellSslCertGetMd5Fingerprint(const CellSslCert sslCert, const uint8_t *buf, uint32_t *plen);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __CELL_SSL_CERT_H__ */
