/* SCE CONFIDENTIAL
PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
* Copyright (C) 2005 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/


#ifndef __CELL_SYNC_BARRIER_H__
#define __CELL_SYNC_BARRIER_H__

#include <stdint.h>

/**
 *  @addtogroup SYNC SYNC
 */
/**
 *  @addtogroup PU PU
 *  @ingroup SYNC
 */
/**
 *  @addtogroup CellSyncBarrier
 *  @ingroup PU
 */
/*@{*/

#include <cell/sync/error.h>

typedef union _CellSyncBarrier {
	struct _CellSyncBarrier_count{
		uint16_t count;
		uint16_t total_count;
	}count;
	uint32_t uint_val;
} CellSyncBarrier;
#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



int
cellSyncBarrierInitialize(CellSyncBarrier *barrier, uint16_t total_count);

int
cellSyncBarrierNotify(CellSyncBarrier *barrier);

int
cellSyncBarrierTryNotify(CellSyncBarrier *barrier);

int
cellSyncBarrierWait(CellSyncBarrier *barrier);

int
cellSyncBarrierTryWait(CellSyncBarrier *barrier);


#ifdef __cplusplus
}
#endif /* __cplusplus */

/*@}*/

#endif /* __CELL_SYNC_BARRIER_H__ */
