/*   SCE CONFIDENTIAL                                       */
/*   PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006 */
/*   Copyright (C) 2006 Sony Computer Entertainment Inc.    */
/*   All Rights Reserved.                                   */

/**
 * \ingroup all_syscall
 * \defgroup spu SPU image
 * \brief system calls for SPU program images
 * 
 * Interfaces defined in sys/spu_image.h
 *
 * Refer to <i>Cell OS Lv-2 User's Manual</i> for the detailed description. 
 */

/*@{*/

#ifndef __LV2_KERNEL_SPU_SYSCALL_SPU_IMAGE_H__
#define __LV2_KERNEL_SPU_SYSCALL_SPU_IMAGE_H__

#include <sys/cdefs.h>
#include <sys/syscall.h>
#include <sys/integertypes.h>
#include <sys/return_code.h>
#include <sys/types.h>

#include "spu_thread.h"

CDECL_BEGIN


#define SYS_SPU_IMAGE_PROTECT       0x0U
#define SYS_SPU_IMAGE_DIRECT        0x1U

extern int sys_spu_image_import(sys_spu_image_t * img, const void *src,
								uint32_t type);
extern int sys_spu_image_close(sys_spu_image_t * img);

static inline int sys_spu_image_open(sys_spu_image_t * img, const char *path)
{
	system_call(2, SYS_SPU_IMAGE_OPEN, (uint32_t) img, (uint32_t) path);

#ifdef REG_PASS_SYS_SPU_IMAGE_OPEN
	REG_PASS_SYS_SPU_IMAGE_OPEN;
#endif
	return_to_user_prog(int);
}



/*@}*/

CDECL_END

#endif /* __LV2_KERNEL_SPU_SYSCALL_SPU_IMAGE_H__ */
