/*   SCE CONFIDENTIAL                                       */
/*   PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006 */
/*   Copyright (C) 2005 Sony Computer Entertainment Inc.    */
/*   All Rights Reserved.                                   */

#ifndef __SYS_SYS_SYSCALL_H__
#define __SYS_SYS_SYSCALL_H__

#define SYS_PROCESS_GETPID                                            1
#define SYS_PROCESS_WAIT_FOR_CHILD                                    2
#define SYS_PROCESS_EXIT                                              3
#define SYS_PROCESS_GET_STATUS                                        4
#define SYS_PROCESS_DETACH_CHILD                                      5
#define SYS_PROCESS_GETPPID                                          18
#define SYS_PROCESS_KILL                                             19
#define SYS_PPU_THREAD_YIELD                                         43
#define SYS_PPU_THREAD_JOIN                                          44
#define SYS_PPU_THREAD_DETACH                                        45
#define SYS_PPU_THREAD_GET_JOIN_STATE                                46
#define SYS_PPU_THREAD_SET_PRIORITY                                  47
#define SYS_PPU_THREAD_GET_PRIORITY                                  48
#define SYS_PPU_THREAD_GET_STACK_INFORMATION                         49
#define SYS_PPU_THREAD_STOP                                          50
#define SYS_PPU_THREAD_RESTART                                       51
#define SYS_TRACE_CREATE                                             60
#define SYS_TRACE_START                                              61
#define SYS_TRACE_STOP                                               62
#define SYS_TRACE_UPDATE_TOP_INDEX                                   63
#define SYS_TRACE_DESTROY                                            64
#define SYS_TRACE_DRAIN                                              65
#define SYS_TRACE_ATTACH_PROCESS                                     66
#define SYS_TIMER_CREATE                                             70
#define SYS_TIMER_DESTROY                                            71
#define SYS_TIMER_GET_INFORMATION                                    72
#define _SYS_TIMER_START                                             73
#define SYS_TIMER_STOP                                               74
#define SYS_TIMER_CONNECT_EVENT_QUEUE                                75
#define SYS_TIMER_DISCONNECT_EVENT_QUEUE                             76
#define SYS_INTERRUPT_TAG_CREATE                                     80
#define SYS_INTERRUPT_TAG_DESTROY                                    81
#define _SYS_INTERRUPT_THREAD_ESTABLISH                              84
#define SYS_INTERRUPT_THREAD_EOI                                     88
#define _SYS_INTERRUPT_THREAD_DISESTABLISH                           89
#define SYS_MUTEX_CREATE                                            100
#define SYS_MUTEX_DESTROY                                           101
#define SYS_MUTEX_LOCK                                              102
#define SYS_MUTEX_TRYLOCK                                           103
#define SYS_MUTEX_UNLOCK                                            104
#define SYS_COND_CREATE                                             105
#define SYS_COND_DESTROY                                            106
#define SYS_COND_WAIT                                               107
#define SYS_COND_SIGNAL                                             108
#define SYS_COND_SIGNAL_ALL                                         109
#define SYS_SYNCPOINT_CREATE                                        110
#define SYS_SYNCPOINT_DESTROY                                       111
#define SYS_SYNCPOINT_WAIT                                          112
#define SYS_SYNCPOINT_WAKEUP_ALL                                    113
#define SYS_RWLOCK_CREATE                                           120
#define SYS_RWLOCK_DESTROY                                          121
#define SYS_RWLOCK_RLOCK                                            122
#define SYS_RWLOCK_TRYRLOCK                                         123
#define SYS_RWLOCK_RUNLOCK                                          124
#define SYS_RWLOCK_WLOCK                                            125
#define SYS_RWLOCK_TRYWLOCK                                         126
#define SYS_RWLOCK_WUNLOCK                                          127
#define SYS_EVENT_QUEUE_CREATE                                      128
#define SYS_EVENT_QUEUE_DESTROY                                     129
#define SYS_EVENT_QUEUE_RECEIVE                                     130
#define SYS_EVENT_QUEUE_TRYRECEIVE                                  131
#define SYS_EVENT_QUEUE_DRAIN                                       133
#define SYS_EVENT_PORT_CREATE                                       134
#define SYS_EVENT_PORT_DESTROY                                      135
#define SYS_EVENT_PORT_CONNECT_LOCAL                                136
#define SYS_EVENT_PORT_DISCONNECT                                   137
#define SYS_EVENT_PORT_SEND                                         138
#define SYS_EVENT_PORT_CONNECT_IPC                                  140
#define SYS_TIMER_USLEEP                                            141
#define SYS_TIMER_SLEEP                                             142
#define SYS_TIME_GET_CURRENT_TIME                                   145
#define SYS_TIME_GET_TIMEBASE_FREQUENCY                             147
#define SYS_RAW_SPU_CREATE_INTERRUPT_TAG                            150
#define SYS_RAW_SPU_SET_INT_MASK                                    151
#define SYS_RAW_SPU_GET_INT_MASK                                    152
#define SYS_RAW_SPU_SET_INT_STAT                                    153
#define SYS_RAW_SPU_GET_INT_STAT                                    154
#define SYS_SPU_IMAGE_OPEN                                          156
#define SYS_RAW_SPU_CREATE                                          160
#define SYS_RAW_SPU_DESTROY                                         161
#define SYS_RAW_SPU_READ_PUINT_MB                                   163
#define SYS_SPU_THREAD_GET_EXIT_STATUS                              165
#define SYS_SPU_THREAD_SET_ARGUMENT                                 166
#define SYS_SPU_THREAD_GROUP_START_ON_EXIT                          167
#define SYS_SPU_INITIALIZE                                          169
#define SYS_SPU_THREAD_GROUP_CREATE                                 170
#define SYS_SPU_THREAD_GROUP_DESTROY                                171
#define SYS_SPU_THREAD_INITIALIZE                                   172
#define SYS_SPU_THREAD_GROUP_START                                  173
#define SYS_SPU_THREAD_GROUP_SUSPEND                                174
#define SYS_SPU_THREAD_GROUP_RESUME                                 175
#define SYS_SPU_THREAD_GROUP_YIELD                                  176
#define SYS_SPU_THREAD_GROUP_TERMINATE                              177
#define SYS_SPU_THREAD_GROUP_JOIN                                   178
#define SYS_SPU_THREAD_GROUP_SET_PRIORITY                           179
#define SYS_SPU_THREAD_GROUP_GET_PRIORITY                           180
#define SYS_SPU_THREAD_WRITE_LS                                     181
#define SYS_SPU_THREAD_READ_LS                                      182
#define SYS_SPU_THREAD_WRITE_SNR                                    184
#define SYS_SPU_THREAD_GROUP_CONNECT_EVENT                          185
#define SYS_SPU_THREAD_GROUP_DISCONNECT_EVENT                       186
#define SYS_SPU_THREAD_SET_SPU_CFG                                  187
#define SYS_SPU_THREAD_GET_SPU_CFG                                  188
#define SYS_SPU_THREAD_WRITE_SPU_MB                                 190
#define SYS_SPU_THREAD_CONNECT_EVENT                                191
#define SYS_SPU_THREAD_DISCONNECT_EVENT                             192
#define SYS_SPU_THREAD_BIND_QUEUE                                   193
#define SYS_SPU_THREAD_UNBIND_QUEUE                                 194
#define SYS_RAW_SPU_SET_SPU_CFG                                     196
#define SYS_RAW_SPU_GET_SPU_CFG                                     197
#define CONSOLE_PUTC                                                200
#define CONSOLE_GETC                                                201
#define SYS_PSEUDO_FS_READ                                          209
#define SYS_PSEUDO_FS_WRITE                                         210
#define SYS_PSEUDO_FS_APPEND                                        211
#define CONSOLE_WRITE                                               213
#define SYS_PSEUDO_FS_GET_FILE_SIZE                                 214
#define LOGICAL_CONSOLE_OPEN                                        215
#define LOGICAL_CONSOLE_CLOSE                                       216
#define LOGICAL_CONSOLE_GETC                                        217
#define LOGICAL_CONSOLE_PUTC                                        218
#define LOGICAL_CONSOLE_FLUSH                                       219
#define SYS_PSEUDO_FS_TRUNCATE                                      295
#define SYS_PSEUDO_FS_GET_DENTS                                     296
#define LOGICAL_CONSOLE_TRY_GETC                                    302
#define SYS_HW_SET_VMX_ROUNDING_MODE                                303
#define SYS_MMAPPER_FREE_SHARED_MEMORY                              329
#define SYS_MMAPPER_ALLOCATE_ADDRESS                                330
#define SYS_MMAPPER_FREE_ADDRESS                                    331
#define SYS_MMAPPER_ALLOCATE_SHARED_MEMORY                          332
#define SYS_MMAPPER_SET_SHARED_MEMORY_FLAG                          333
#define SYS_MMAPPER_MAP_SHARED_MEMORY                               334
#define SYS_MMAPPER_UNMAP_SHARED_MEMORY                             335
#define SYS_MMAPPER_CHANGE_ADDRESS_ACCESS_RIGHT                     336
#define SYS_MMAPPER_SEARCH_AND_MAP                                  337
#define SYS_MMAPPER_GET_SHARED_MEMORY_ATTRIBUTE                     338
#define SYS_MEMORY_ALLOCATE                                         348
#define SYS_MEMORY_FREE                                             349
#define SYS_MEMORY_GET_PAGE_ATTRIBUTE                               351
#define SYS_MEMORY_GET_USER_MEMORY_SIZE                             352
#define _SYS_PRX_LOAD_MODULE                                        480
#define _SYS_PRX_START_MODULE                                       481
#define _SYS_PRX_STOP_MODULE                                        482
#define _SYS_PRX_UNLOAD_MODULE                                      483
#define _SYS_PRX_REGISTER_MODULE                                    484
#define _SYS_PRX_QUERY_MODULE                                       485
#define _SYS_PRX_REGISTER_LIBRARY                                   486
#define _SYS_PRX_UNREGISTER_LIBRARY                                 487
#define _SYS_PRX_LINK_LIBRARY                                       488
#define _SYS_PRX_UNLINK_LIBRARY                                     489
#define _SYS_PRX_QUERY_LIBRARY                                      490
#define SYS_PRX_DBG_GET_MODULE_LIST                                 492
#define SYS_PRX_DBG_GET_MODULE_INFO                                 493
#define _SYS_PRX_START                                              498
#define _SYS_PRX_STOP                                               499
#define SYS_STORAGE_OPEN                                            600
#define SYS_STORAGE_CLOSE                                           601
#define SYS_STORAGE_READ                                            602
#define SYS_STORAGE_WRITE                                           603
#define SYS_STORAGE_SEND_DEVICE_COMMAND                             604
#define SYS_STORAGE_ASYNC_CONFIGURE                                 605
#define SYS_STORAGE_ASYNC_READ                                      606
#define SYS_STORAGE_ASYNC_WRITE                                     607
#define SYS_STORAGE_ASYNC_CANCEL                                    608
#define SYS_STORAGE_GET_DEVICE_INFO                                 609
#define SYS_STORAGE_GET_DEVICE_CONFIG                               610
#define SYS_STORAGE_REPORT_DEVICES                                  611
#define SYS_STORAGE_CONFIGURE_MEDIUM_EVENT                          612
#define SYS_STORAGE_SET_MEDIUM_POLLING_INTERVAL                     613
#define SYS_IO_BUFFER_CREATE                                        624
#define SYS_IO_BUFFER_DESTROY                                       625
#define SYS_IO_BUFFER_ALLOCATE                                      626
#define SYS_IO_BUFFER_FREE                                          627
#define SYS_GPIO_SET                                                630
#define SYS_GPIO_GET                                                631
#define SYS_RSX_DEVICE_OPEN                                         666
#define SYS_RSX_DEVICE_CLOSE                                        667
#define SYS_RSX_MEMORY_ALLOCATE                                     668
#define SYS_RSX_MEMORY_FREE                                         669
#define SYS_RSX_CONTEXT_ALLOCATE                                    670
#define SYS_RSX_CONTEXT_FREE                                        671
#define SYS_RSX_CONTEXT_IOMAP                                       672
#define SYS_RSX_CONTEXT_IOUNMAP                                     673
#define SYS_RSX_CONTEXT_ATTRIBUTE                                   674
#define SYS_RSX_DEVICE_MAP                                          675
#define SYS_RSX_DEVICE_UNMAP                                        676
#define SYS_RSX_ATTRIBUTE                                           677
#define SYS_IOSYS_INFRA_TEST_OPEN                                   697
#define SYS_IOSYS_INFRA_TEST_EXECUTE                                698
#define SYS_IOSYS_INFRA_TEST_CLOSE                                  699
#define SYS_DECI3_OPEN                                              880
#define SYS_DECI3_CREATE_EVENT_PATH                                 881
#define SYS_DECI3_CLOSE                                             882
#define SYS_DECI3_SEND                                              883
#define SYS_DECI3_RECEIVE                                           884

#define MAX_NUM_OF_SYSTEM_CALLS                                    1024

/* The following macros represent the numbers for the SPU library functions. */
#define SYS_SPU_THREAD_EXIT                                           1
#define SYS_SPU_THREAD_GROUP_EXIT                                     2
#define SYS_SPU_THREAD_YIELD                                          3
#define SYS_SPU_THREAD_RECEIVE_EVENT                                  4
#define SYS_SPU_THREAD_TRYRECEIVE_EVENT                               5
#define SYS_SPU_THREAD_SEND_EVENT                                     6
#define SYS_SPU_THREAD_THROW_EVENT                                    7

#include <sys/types.h>

/*
 * Load the arguments and system call numbers to the registers, and issue
 * the "sc" instruction.
 *
 * \param nr The number of arguments
 * \param syscall_num The system call number
 * \param args The argument list
 */
#define system_call(nr, syscall_num, args...)                              \
register uint64_t p1 __asm__ ("3");                                        \
register uint64_t p2 __asm__ ("4");                                        \
register uint64_t p3 __asm__ ("5");                                        \
register uint64_t p4 __asm__ ("6");                                        \
register uint64_t p5 __asm__ ("7");                                        \
register uint64_t p6 __asm__ ("8");                                        \
register uint64_t p7 __asm__ ("9");                                        \
register uint64_t p8 __asm__ ("10");                                       \
register uint64_t n  __asm__ ("11");                                       \
                                                                           \
sc_load_args_##nr(syscall_num, args);                                      \
                                                                           \
__asm__ volatile ("sc"                                                     \
                  : "=r" (p1), "=r" (p2), "=r" (p3), "=r" (p4),            \
                    "=r" (p5), "=r" (p6), "=r" (p7), "=r" (p8), "=r" (n)   \
                  : "r" (p1), "r" (p2), "r" (p3), "r" (p4),                \
                    "r" (p5), "r" (p6), "r" (p7), "r" (p8), "r" (n)        \
                  : "0", "12", "lr", "ctr", "xer", "cr0", "cr1", "cr5", "cr6", "cr7", "memory") \

/*
 * Calling this macro lets the stub return to the user program.
 * 
 * \param ret_type The return parameter type
 */
#define return_to_user_prog(ret_type) return (ret_type)(p1)


/*
 * Macros to obtain the register passing return arguments.
 */
#define register_passing_1(type) (type)(p2)
#define register_passing_2(type) (type)(p3)
#define register_passing_3(type) (type)(p4)
#define register_passing_4(type) (type)(p5)
#define register_passing_5(type) (type)(p6)
#define register_passing_6(type) (type)(p7)
#define register_passing_7(type) (type)(p8)

/*
 * The sc_load_args_X macros load parameters to the input registers. 
 */
#define sc_load_args_0(syscall_num, dummy...) \
n = syscall_num \

#define sc_load_args_1(syscall_num, arg1) \
sc_load_args_0(syscall_num); \
p1 = (uint64_t)(arg1)

#define sc_load_args_2(syscall_num, arg1, arg2) \
sc_load_args_1(syscall_num, arg1); \
p2 = (uint64_t)(arg2)

#define sc_load_args_3(syscall_num, arg1, arg2, arg3) \
sc_load_args_2(syscall_num, arg1, arg2); \
p3 = (uint64_t)(arg3)

#define sc_load_args_4(syscall_num, arg1, arg2, arg3, arg4) \
sc_load_args_3(syscall_num, arg1, arg2, arg3); \
p4 = (uint64_t)(arg4)

#define sc_load_args_5(syscall_num, arg1, arg2, arg3, arg4, arg5) \
sc_load_args_4(syscall_num, arg1, arg2, arg3, arg4); \
p5 = (uint64_t)(arg5)

#define sc_load_args_6(syscall_num, arg1, arg2, arg3, arg4, arg5, arg6) \
sc_load_args_5(syscall_num, arg1, arg2, arg3, arg4, arg5); \
p6 = (uint64_t)(arg6)

#define sc_load_args_7(syscall_num, arg1, arg2, arg3, arg4, arg5, arg6, arg7) \
sc_load_args_6(syscall_num, arg1, arg2, arg3, arg4, arg5, arg6); \
p7 = (uint64_t)(arg7)

#define sc_load_args_8(syscall_num, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8) \
sc_load_args_7(syscall_num, arg1, arg2, arg3, arg4, arg5, arg6, arg7); \
p8 = (uint64_t)(arg8)



/*
 * Macros used for register passing output arguments.
 */
#define REG_PASS_SYS_EVENT_QUEUE_RECEIVE      \
event->source = register_passing_1(uint64_t); \
event->data1  = register_passing_2(uint64_t); \
event->data2  = register_passing_3(uint64_t); \
event->data3  = register_passing_4(uint64_t)


#endif /* __SYS_SYS_SYSCALL_H__ */
